/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.optimizer.walker.topdown;

import io.brackit.query.compiler.AST;
import io.brackit.query.util.Cmp;

public final class CmpUtil {
    public static Cmp cmp(AST cmpNode) {
        return switch (cmpNode.getType()) {
            case 40, 46 -> Cmp.eq;
            case 45, 51 -> Cmp.ge;
            case 43, 49 -> Cmp.le;
            case 42, 48 -> Cmp.lt;
            case 44, 50 -> Cmp.gt;
            case 41, 47 -> Cmp.ne;
            default -> throw new IllegalArgumentException();
        };
    }

    public static int type(Cmp cmp, boolean isGCmp) {
        return switch (cmp) {
            default -> throw new MatchException(null, null);
            case Cmp.eq -> {
                if (isGCmp) {
                    yield 40;
                }
                yield 46;
            }
            case Cmp.ge -> {
                if (isGCmp) {
                    yield 45;
                }
                yield 51;
            }
            case Cmp.gt -> {
                if (isGCmp) {
                    yield 44;
                }
                yield 50;
            }
            case Cmp.le -> {
                if (isGCmp) {
                    yield 43;
                }
                yield 49;
            }
            case Cmp.lt -> {
                if (isGCmp) {
                    yield 42;
                }
                yield 48;
            }
            case Cmp.ne -> isGCmp ? 41 : 47;
        };
    }

    public static boolean isGCmp(AST cmp) {
        return switch (cmp.getType()) {
            case 40, 42, 43, 44, 45 -> true;
            default -> false;
        };
    }
}

