/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.profiler;

import io.brackit.query.Query;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.AST;
import io.brackit.query.compiler.profiler.ProfileExpr;
import io.brackit.query.compiler.profiler.ProfileOperator;
import io.brackit.query.compiler.profiler.ProfilingNode;
import io.brackit.query.compiler.translator.TopDownTranslator;
import io.brackit.query.jdm.Expr;
import io.brackit.query.module.MainModule;
import io.brackit.query.operator.Operator;
import io.brackit.query.util.dot.DotContext;
import java.io.File;
import java.util.Map;

public class ProfilingCompiler
extends TopDownTranslator {
    public static final String PLOT_TYPE = "svg";
    private ProfilingNode parent;
    private ProfilingNode child;
    private ProfileOperator pending;

    public ProfilingCompiler(Map<QNm, Str> options) {
        super(options);
    }

    @Override
    protected Expr anyExpr(AST node) throws QueryException {
        ProfileExpr profileExpr = new ProfileExpr();
        ProfilingNode savedParent = this.parent;
        this.parent = profileExpr;
        Expr e = super.anyExpr(node);
        profileExpr.setExpr(e);
        this.parent = savedParent;
        if (this.parent != null) {
            this.parent.addChild(profileExpr);
        }
        return profileExpr;
    }

    @Override
    protected Operator anyOp(Operator in, AST node) throws QueryException {
        ProfileOperator profileOp = new ProfileOperator();
        ProfilingNode savedParent = this.parent;
        this.parent = profileOp;
        Operator op = super.anyOp(in, node);
        profileOp.setOp(op);
        this.parent = savedParent;
        if (this.parent != null) {
            this.parent.addChild(profileOp);
        }
        return profileOp;
    }

    public static void visualize(Query xq, String outputDir) {
        DotContext dotCtx = new DotContext();
        ((ProfileExpr)((MainModule)xq.getModule()).getBody()).toDot(dotCtx);
        ProfilingCompiler.createDot(outputDir, "expr", dotCtx);
    }

    private static void createDot(String outputDir, String name, DotContext dotCtx) {
        try {
            File f = File.createTempFile(name, "dot");
            dotCtx.write(f);
            f.deleteOnExit();
            String outfile = outputDir + "/" + name + "s.svg";
            String command = "dot -Tsvg -o" + outfile + " " + String.valueOf(f);
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

