/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.profiler;

import io.brackit.query.util.dot.DotContext;
import io.brackit.query.util.dot.DotNode;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ProfilingNode {
    private static final AtomicInteger idSource = new AtomicInteger(1);
    protected final int id = idSource.getAndIncrement();
    protected ProfilingNode[] ce;
    protected int cel;

    void prependChild(ProfilingNode c) {
        if (c == this) {
            throw new RuntimeException();
        }
        if (this.ce == null) {
            this.ce = new ProfilingNode[]{c};
            ++this.cel;
        } else {
            if (this.cel == this.ce.length) {
                this.ce = Arrays.copyOf(this.ce, this.cel * 3 / 2 + 1);
            }
            System.arraycopy(this.ce, 0, this.ce, 1, this.cel);
            this.ce[0] = c;
            ++this.cel;
        }
    }

    void addChild(ProfilingNode c) {
        if (c == this) {
            throw new RuntimeException();
        }
        if (this.ce == null) {
            this.ce = new ProfilingNode[]{c};
            ++this.cel;
        } else {
            if (this.cel == this.ce.length) {
                this.ce = Arrays.copyOf(this.ce, this.cel * 3 / 2 + 1);
            }
            this.ce[this.cel++] = c;
        }
    }

    protected abstract String getName();

    protected abstract void addFields(DotNode var1);

    public void toDot(DotContext dotCtx) {
        DotNode node = dotCtx.pushChildNode(this.getName());
        this.addFields(node);
        for (int i = 0; i < this.cel; ++i) {
            this.ce[i].toDot(dotCtx);
        }
        dotCtx.popChildNode();
    }
}

