/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.compiler.translator;

import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.translator.Reference;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.util.log.Logger;
import java.io.PrintWriter;
import java.util.Arrays;

public class Binding {
    private static final Logger log = Logger.getLogger(Binding.class);
    final QNm name;
    final SequenceType type;
    final Binding prev;
    Binding[] next;
    Reference[] refs;
    int refCount;
    int nextCount;

    Binding(QNm name, SequenceType type, Binding prev) {
        this.name = name;
        this.type = type;
        this.prev = prev;
    }

    public QNm getName() {
        return this.name;
    }

    public SequenceType getType() {
        return this.type;
    }

    void unchain() {
        this.prev.next[--this.prev.nextCount] = null;
        for (int i = 0; i < this.nextCount; ++i) {
            this.prev.append(this.next[i]);
        }
    }

    void append(Binding binding) {
        if (this.next == null) {
            this.next = new Binding[2];
        }
        if (this.nextCount == this.next.length) {
            this.next = Arrays.copyOf(this.next, this.next.length * 3 / 2 + 1);
        }
        this.next[this.nextCount++] = binding;
    }

    void connect(Reference variable) {
        if (this.refs == null) {
            this.refs = new Reference[2];
        }
        if (this.refCount == this.refs.length) {
            this.refs = Arrays.copyOf(this.refs, this.refs.length * 3 / 2 + 1);
        }
        this.refs[this.refCount++] = variable;
    }

    public boolean isReferenced() {
        return this.refCount > 0;
    }

    void resolvePositions(int currentPos) {
        int i;
        if (this.isReferenced()) {
            ++currentPos;
            if (log.isTraceEnabled()) {
                log.trace(String.format("Setting reference pos of %s to %s", this.name, currentPos));
            }
            for (i = 0; i < this.refCount; ++i) {
                this.refs[i].setPos(currentPos);
            }
        }
        for (i = 0; i < this.nextCount; ++i) {
            this.next[i].resolvePositions(currentPos);
        }
    }

    public void dump(PrintWriter out) {
        this.dumpIndented(out, 0);
    }

    private void dumpIndented(PrintWriter out, int indent) {
        out.print(" -> ");
        out.print(this.name);
        out.print("(");
        out.print(this.refCount);
        out.print(" refs)");
        indent += 11 + this.name.toString().length() + Integer.toString(this.refCount).length();
        if (this.nextCount > 0) {
            this.next[0].dumpIndented(out, indent);
            for (int i = 1; i < this.nextCount; ++i) {
                out.println();
                for (int j = 0; j < indent; ++j) {
                    out.print(" ");
                }
                this.next[i].dumpIndented(out, indent);
            }
        }
    }

    public String toString() {
        return this.name.toString();
    }
}

