/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Bool;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;

public class AndExpr
implements Expr {
    private final Expr firstExpr;
    private final Expr secondExpr;

    public AndExpr(Expr firstExpr, Expr secondExpr) {
        this.firstExpr = firstExpr;
        this.secondExpr = secondExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        Sequence firstResult = this.firstExpr.evaluate(ctx, tuple);
        if (firstResult == null || !firstResult.booleanValue()) {
            return Bool.FALSE;
        }
        Sequence secondResult = this.secondExpr.evaluate(ctx, tuple);
        return secondResult != null && secondResult.booleanValue() ? Bool.TRUE : Bool.FALSE;
    }

    @Override
    public boolean isUpdating() {
        return this.firstExpr.isUpdating() || this.secondExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

