/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.type.ArrayType;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.ItemSequence;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.util.ExprUtil;

public final class ArrayAccessExpr
implements Expr {
    private final Expr expr;
    private final Expr index;

    public ArrayAccessExpr(Expr expr, Expr index) {
        this.expr = expr;
        this.index = index;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence sequence = this.expr.evaluate(ctx, tuple);
        if (sequence == null) {
            return null;
        }
        if (sequence instanceof ItemSequence) {
            ItemSequence itemSequence = (ItemSequence)sequence;
            return this.getLazySequence(ctx, tuple, itemSequence);
        }
        if (sequence instanceof LazySequence) {
            LazySequence lazySequence = (LazySequence)sequence;
            return this.getLazySequence(ctx, tuple, lazySequence);
        }
        Item currItem = ExprUtil.asItem(sequence);
        if (!(currItem instanceof Array)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", currItem.itemType(), ArrayType.ARRAY);
        }
        Array array = (Array)currItem;
        Item itemIndex = this.index.evaluateToItem(ctx, tuple);
        if (itemIndex == null) {
            return this.getLazySequence(ctx, tuple, array);
        }
        if (!(itemIndex instanceof IntNumeric)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", itemIndex.itemType(), Type.INR);
        }
        IntNumeric numericIndex = (IntNumeric)itemIndex;
        if (numericIndex.intValue() < 0) {
            int index = array.len() + numericIndex.intValue();
            if (index < 0) {
                throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Illegal negative index: " + index);
            }
            return array.at(array.len() + numericIndex.intValue());
        }
        return array.at(numericIndex);
    }

    private LazySequence getLazySequence(final QueryContext ctx, final Tuple tuple, final Sequence sequence) {
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    final Iter iter;
                    Iter nestedIter;
                    {
                        this.iter = sequence.iterate();
                    }

                    @Override
                    public Item next() {
                        Item item;
                        if (this.nestedIter != null && (item = this.nestedIter.next()) != null) {
                            return item;
                        }
                        while ((item = this.iter.next()) != null) {
                            if (!(item instanceof Array)) continue;
                            Array array = (Array)item;
                            Item i = ArrayAccessExpr.this.index.evaluateToItem(ctx, tuple);
                            if (i == null) {
                                this.nestedIter = ArrayAccessExpr.this.getLazySequence(ctx, tuple, array).iterate();
                                return this.nestedIter.next();
                            }
                            if (!(i instanceof IntNumeric)) {
                                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", i.itemType(), Type.INR);
                            }
                            IntNumeric intNumeric = (IntNumeric)i;
                            int index = intNumeric.intValue() >= 0 ? intNumeric.intValue() : array.len() + intNumeric.intValue();
                            return array.at(index).evaluateToItem(ctx, tuple);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    private LazySequence getLazySequence(final QueryContext ctx, final Tuple tuple, final Array array) {
        return new LazySequence(this){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    int i = 0;

                    @Override
                    public Item next() {
                        return this.i < array.len() ? array.at(this.i++).evaluateToItem(ctx, tuple) : null;
                    }

                    @Override
                    public void close() {
                    }

                    @Override
                    public Iter.Split split(int min, int max) throws QueryException {
                        return null;
                    }
                };
            }
        };
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        return this.expr.isUpdating() || this.index.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

