/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.expr.SequenceExpr;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jsonitem.array.DArray;
import java.util.List;
import org.magicwerk.brownies.collections.GapList;

public final class ArrayExpr
implements Expr {
    private final Expr[] expr;
    private final boolean[] flatten;

    public ArrayExpr(Expr[] expr, boolean[] flatten) {
        this.expr = expr;
        this.flatten = flatten;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) {
        return this.evaluateToItem(ctx, t);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple t) {
        GapList vals = new GapList();
        for (int i = 0; i < this.expr.length; ++i) {
            Sequence res = this.expr[i].evaluate(ctx, t);
            if (res == null) continue;
            if (!(res instanceof SequenceExpr.EvalSequence) && !this.flatten[i] || res instanceof Item) {
                vals.add((Object)res);
                continue;
            }
            try (Iter it = res.iterate();){
                Item item;
                while ((item = it.next()) != null) {
                    vals.add((Object)item);
                }
                continue;
            }
        }
        return new DArray((List<? extends Sequence>)vals);
    }

    @Override
    public boolean isUpdating() {
        for (Expr e : this.expr) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        for (Expr e : this.expr) {
            if (e.isVacuous()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        boolean first = true;
        for (int i = 0; i < this.expr.length; ++i) {
            if (!first) {
                out.append(", ");
            }
            first = false;
            if (this.flatten[i]) {
                out.append("=");
            }
            out.append(this.expr[i].toString());
        }
        out.append("]");
        return out.toString();
    }

    public static void main(String[] args) {
        new Query("[ 1, '2', 3, (1 > 0) cast as xs:boolean, 1.2343 + 5, =(1,2,3)  ][[4]]").serialize((QueryContext)new BrackitQueryContext(), System.out);
    }
}

