/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jsonitem.array.DArray;
import io.brackit.query.util.ExprUtil;
import java.util.List;
import org.magicwerk.brownies.collections.GapList;

public final class ArrayIndexSliceExpr
implements Expr {
    private final Expr expr;
    private final Expr firstIndex;
    private final Expr secondIndex;
    private final Expr step;

    public ArrayIndexSliceExpr(Expr expr, Expr firstIndex, Expr secondIndex, Expr increment) {
        this.expr = expr;
        this.firstIndex = firstIndex;
        this.secondIndex = secondIndex;
        this.step = increment;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        int lowerBoundIndex;
        Item arrayItem = this.expr.evaluateToItem(ctx, tuple);
        if (arrayItem == null) {
            return null;
        }
        if (!(arrayItem instanceof Array)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", arrayItem.itemType(), Type.INR);
        }
        Array array = (Array)arrayItem;
        Item lowerBoundItem = this.firstIndex.evaluateToItem(ctx, tuple);
        Item upperBoundItem = this.secondIndex.evaluateToItem(ctx, tuple);
        Item stepItem = this.step.evaluateToItem(ctx, tuple);
        if (stepItem != null && !(stepItem instanceof IntNumeric)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", stepItem.itemType(), Type.INR);
        }
        int step = stepItem == null ? 1 : ((IntNumeric)stepItem).intValue();
        if (lowerBoundItem == null) {
            int upperBoundIndex;
            if (upperBoundItem == null) {
                if (step > 0) {
                    return this.getAllItemsFromArray(array, step);
                }
                return this.getAllItemsFromArrayReversed(array, step);
            }
            if (!(upperBoundItem instanceof IntNumeric)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", upperBoundItem.itemType(), Type.INR);
            }
            int upperBoundIndexInt = ((IntNumeric)upperBoundItem).intValue();
            int n = upperBoundIndex = upperBoundIndexInt >= 0 ? upperBoundIndexInt : array.len() + upperBoundIndexInt;
            if (step > 0) {
                Item item;
                Iter it = array.iterate();
                GapList buffer = new GapList(array.len());
                boolean first = true;
                for (int i = 0; (item = it.next()) != null && i < upperBoundIndex; ++i) {
                    if (first) {
                        first = false;
                        buffer.add((Object)item);
                        continue;
                    }
                    if (i % step != 0) continue;
                    buffer.add((Object)item);
                }
                return new DArray((List<? extends Sequence>)buffer);
            }
            GapList buffer = new GapList(array.len());
            for (int i = array.len() - 1; i > upperBoundIndex && i != -1; i += step) {
                Item item = ExprUtil.asItem(array.at(i));
                buffer.add((Object)item);
            }
            return new DArray((List<? extends Sequence>)buffer);
        }
        if (!(lowerBoundItem instanceof IntNumeric)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", lowerBoundItem.itemType(), Type.INR);
        }
        int lowerBoundIndexInt = ((IntNumeric)lowerBoundItem).intValue();
        int n = lowerBoundIndex = lowerBoundIndexInt >= 0 ? lowerBoundIndexInt : array.len() + lowerBoundIndexInt;
        if (upperBoundItem == null) {
            int upperBoundIndex = step >= 0 ? array.len() : -1;
            return this.getArrayItemSlice(array, step, lowerBoundIndex, upperBoundIndex);
        }
        int upperBoundIndexInt = ((IntNumeric)upperBoundItem).intValue();
        int upperBoundIndex = upperBoundIndexInt >= 0 ? upperBoundIndexInt : array.len() + upperBoundIndexInt;
        return this.getArrayItemSlice(array, step, lowerBoundIndex, upperBoundIndex);
    }

    private Sequence getArrayItemSlice(Array array, int step, int lowerBoundIndex, int upperBoundIndex) {
        if (step > 0) {
            return this.getArrayItemSliceSequence(array, lowerBoundIndex, upperBoundIndex, step);
        }
        return this.getArrayItemSliceSequenceReversed(array, lowerBoundIndex, upperBoundIndex, step);
    }

    private Array getArrayItemSliceSequence(Array array, int lowerBoundIndex, int upperBoundIndex, int step) {
        Item item;
        int i;
        Iter it = array.iterate();
        for (i = 0; i < lowerBoundIndex && it.next() != null; ++i) {
        }
        GapList buffer = new GapList(array.len());
        boolean first = true;
        while ((item = it.next()) != null && i < upperBoundIndex) {
            if (first) {
                first = false;
                buffer.add((Object)item);
            } else if (i % step == 0) {
                buffer.add((Object)item);
            }
            ++i;
        }
        return new DArray((List<? extends Sequence>)buffer);
    }

    private Array getArrayItemSliceSequenceReversed(Array array, int lowerBoundIndex, int upperBoundIndex, int step) {
        GapList buffer = new GapList(array.len());
        for (int i = lowerBoundIndex; i > upperBoundIndex && i != -1; i += step) {
            Item item = ExprUtil.asItem(array.at(i));
            buffer.add((Object)item);
        }
        return new DArray((List<? extends Sequence>)buffer);
    }

    private Array getAllItemsFromArray(Array array, int step) {
        Item item;
        Iter it = array.iterate();
        GapList buffer = new GapList(array.len());
        int i = 0;
        boolean first = true;
        while ((item = it.next()) != null) {
            if (first) {
                first = false;
                buffer.add((Object)item);
            } else if (i % step == 0) {
                buffer.add((Object)item);
            }
            ++i;
        }
        return new DArray((List<? extends Sequence>)buffer);
    }

    private Array getAllItemsFromArrayReversed(Array array, int step) {
        GapList buffer = new GapList(array.len());
        for (int i = array.len() - 1; i != -1; i += step) {
            Item item = ExprUtil.asItem(array.at(i));
            buffer.add((Object)item);
        }
        return new DArray((List<? extends Sequence>)buffer);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence res = this.evaluate(ctx, tuple);
        if (res == null || res instanceof Item) {
            return (Item)res;
        }
        GapList values = new GapList();
        try (Iter it = res.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                values.add((Object)item);
            }
        }
        return new DArray((List<? extends Sequence>)values);
    }

    @Override
    public boolean isUpdating() {
        return this.expr.isUpdating() || this.firstIndex.isUpdating() || this.secondIndex.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

