/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.atomic.Una;
import io.brackit.query.expr.ConstructedNodeBuilder;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.module.StaticContext;

public class AttributeExpr
extends ConstructedNodeBuilder
implements Expr {
    protected final StaticContext sctx;
    protected final Expr nameExpr;
    protected final Expr[] valueExpr;
    protected final boolean appendOnly;
    protected final QNm name;

    public AttributeExpr(StaticContext sctx, Expr nameExpr, Expr[] valueExpr, boolean appendOnly) {
        this.sctx = sctx;
        this.nameExpr = nameExpr;
        this.valueExpr = valueExpr;
        this.appendOnly = appendOnly;
        this.name = (QNm)(nameExpr instanceof QNm ? nameExpr : null);
    }

    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        QNm name;
        QNm qNm = name = this.name != null ? this.name : this.buildAttributeName(this.sctx, this.nameExpr.evaluateToItem(ctx, tuple));
        if ("xmlns".equals(name.getPrefix())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Attribute name prefix must not be \"xmlns\"");
        }
        if (name.getPrefix() == null && "xmlns".equals(name.getLocalName())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Attribute name must not be \"xmlns\"");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(name.getNamespaceURI())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Attribute name namespace URI must not be \"http://www.w3.org/2000/xmlns/\"");
        }
        if ("xml".equals(name.getPrefix()) ? !"http://www.w3.org/XML/1998/namespace".equals(name.getNamespaceURI()) : "http://www.w3.org/XML/1998/namespace".equals(name.getNamespaceURI())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Namespace prefix \"xml\" must be bound to namespace URI other than \"http://www.w3.org/XML/1998/namespace\"");
        }
        Object stringValue = "";
        for (Expr e : this.valueExpr) {
            Sequence content = e.evaluate(ctx, tuple);
            stringValue = (String)stringValue + this.buildAttributeContent(content);
        }
        if (this.appendOnly) {
            ((Node)tuple.get(tuple.getSize() - 1)).setAttribute(name, new Una((String)stringValue));
            return null;
        }
        Object attribute = ctx.getNodeFactory().attribute(name, new Str((String)stringValue));
        return attribute;
    }

    @Override
    public boolean isUpdating() {
        if (this.nameExpr.isUpdating()) {
            return this.isUpdating();
        }
        for (Expr e : this.valueExpr) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return "attribute";
    }
}

