/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.translator.Reference;
import io.brackit.query.expr.Variable;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.sequence.TypedSequence;
import io.brackit.query.util.ExprUtil;

public class BoundVariable
extends Variable
implements Reference {
    private int pos = -1;

    public BoundVariable(QNm name, SequenceType type) {
        super(name, type);
    }

    public BoundVariable(QNm name, int pos) {
        super(name);
        this.pos = pos;
    }

    @Override
    public void setPos(int pos) {
        this.pos = pos;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence s;
        try {
            s = tuple.get(this.pos);
        }
        catch (QueryException e) {
            throw new QueryException(e, e.getCode(), "Could not resolve variable %s in tuple[%s] at position %s: %s", this.name, tuple.getSize(), this.pos, tuple);
        }
        if (this.type != null) {
            s = TypedSequence.toTypedSequence(this.type, s);
        }
        return s;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence s;
        try {
            s = tuple.get(this.pos);
        }
        catch (QueryException e) {
            throw new QueryException(e, e.getCode(), "Could not resolve variable %s in tuple at position %s: %s", this.name, tuple.getSize(), this.pos, tuple);
        }
        if (this.type != null) {
            return TypedSequence.toTypedItem(this.type, s);
        }
        return ExprUtil.asItem(s);
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

