/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.QNm;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.module.StaticContext;

public class Castable
implements Expr {
    private final StaticContext sctx;
    private final Expr expr;
    private final Type target;
    private final boolean allowEmptySequence;

    public Castable(StaticContext sctx, Expr expr, Type targetType, boolean allowEmptySequence) {
        this.sctx = sctx;
        this.expr = expr;
        this.target = targetType;
        this.allowEmptySequence = allowEmptySequence;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence sequence = this.expr.evaluate(ctx, tuple);
        if (sequence == null) {
            return this.allowEmptySequence ? Bool.TRUE : Bool.FALSE;
        }
        Item item = null;
        if (sequence instanceof Item) {
            item = (Item)sequence;
        } else {
            try (Iter it = sequence.iterate();){
                item = it.next();
                if (item == null) {
                    Bool bool = this.allowEmptySequence ? Bool.TRUE : Bool.FALSE;
                    return bool;
                }
                if (it.next() != null) {
                    Bool bool = Bool.FALSE;
                    return bool;
                }
            }
        }
        try {
            Cast.cast(this.sctx, item, this.target, this.allowEmptySequence);
            return Bool.TRUE;
        }
        catch (QueryException e) {
            QNm code = e.getCode();
            if (code.eq(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) || code.eq(ErrorCode.ERR_UNKNOWN_ATOMIC_SCHEMA_TYPE) || code.eq(ErrorCode.ERR_INVALID_LEXICAL_VALUE) || code.eq(ErrorCode.ERR_INVALID_VALUE_FOR_CAST) || code.eq(ErrorCode.ERR_ILLEGAL_CAST_TARGET_TYPE)) {
                return Bool.FALSE;
            }
            throw e;
        }
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

