/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.XMLChar;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.Whitespace;
import java.util.ArrayList;

public abstract class ConstructedNodeBuilder {
    protected Node<?> copy(QueryContext ctx, Node<?> source) {
        return ctx.getNodeFactory().copy(source);
    }

    protected void buildContentSequence(QueryContext ctx, ContentSink sink, Sequence source) {
        if (source != null) {
            if (source instanceof Item) {
                this.addContent(ctx, sink, (Item)source, null);
            } else {
                Node<?> prevSibling = null;
                try (Iter s = source.iterate();){
                    Item next;
                    while ((next = s.next()) != null) {
                        prevSibling = this.addContent(ctx, sink, next, prevSibling);
                    }
                }
            }
        }
    }

    private Node<?> addContent(QueryContext ctx, ContentSink sink, Item item, Node<?> prevSibling) {
        if (item instanceof Node) {
            Node contentNode = (Node)item;
            if (contentNode.getKind() == Kind.ATTRIBUTE) {
                if (prevSibling != null) {
                    throw new QueryException(ErrorCode.ERR_TYPE_CONTENT_SEQUENCE_ATTRIBUTE_FOLLOWING_NON_ATTRIBUTE);
                }
                sink.addAttribute(ctx, contentNode);
                return null;
            }
            if (contentNode.getKind() == Kind.DOCUMENT) {
                try (Stream children = contentNode.getChildren();){
                    Node child;
                    while ((child = (Node)children.next()) != null) {
                        prevSibling = child;
                        sink.addNode(ctx, prevSibling);
                    }
                }
                return prevSibling;
            }
            sink.addNode(ctx, contentNode);
            return contentNode;
        }
        if (prevSibling != null && prevSibling.getKind() == Kind.TEXT) {
            prevSibling.setValue(new Str(prevSibling.getValue().stringValue() + " " + ((Atomic)item).stringValue()));
            return prevSibling;
        }
        Object node = ctx.getNodeFactory().text(new Str(((Atomic)item).stringValue()));
        return sink.addNode(ctx, (Node<?>)node);
    }

    protected String buildTextContent(Sequence source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Item) {
            return ((Item)source).atomize().stringValue();
        }
        StringBuilder buf = new StringBuilder();
        try (Iter it = source.iterate();){
            Item item = it.next();
            if (item != null) {
                buf.append(item.atomize().stringValue());
                while ((item = it.next()) != null) {
                    buf.append(' ');
                    buf.append(item.atomize().stringValue());
                }
            }
        }
        return buf.toString();
    }

    protected String buildAttributeContent(Sequence content) {
        if (content == null) {
            return "";
        }
        if (content instanceof Item) {
            return ((Item)content).atomize().stringValue();
        }
        try (Iter s = content.iterate();){
            Object stringValue = "";
            Item next = s.next();
            if (next != null) {
                stringValue = next.atomize().stringValue();
                next = s.next();
                if (next != null) {
                    StringBuilder builder = new StringBuilder();
                    while (next != null) {
                        builder.append(" ");
                        builder.append(next.atomize().stringValue());
                        next = s.next();
                    }
                    stringValue = (String)stringValue + builder.toString();
                }
            }
            String string = stringValue;
            return string;
        }
    }

    protected QNm buildElementName(StaticContext ctx, Item name) {
        if (name == null) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
        }
        Atomic atomicName = name.atomize();
        Type nameType = atomicName.type();
        if (nameType.instanceOf(Type.QNM)) {
            return (QNm)name;
        }
        if (nameType.instanceOf(Type.STR) || nameType.instanceOf(Type.UNA)) {
            QNm qnm = new QNm(atomicName.stringValue());
            if (qnm.getPrefix() != null && !qnm.getPrefix().isEmpty()) {
                String uri = ctx.getNamespaces().resolve(qnm.getPrefix());
                if (uri == null) {
                    throw new QueryException(ErrorCode.ERR_UNKNOWN_NS_PREFIX_IN_COMP_CONSTR, "Statically unkown namespace prefix in computed element constructor: '%s'", qnm.getPrefix());
                }
                return new QNm(uri, null, qnm.getLocalName());
            }
            String uri = ctx.getNamespaces().getDefaultElementNamespace();
            if (uri == null || uri.isEmpty()) {
                return qnm;
            }
            return new QNm(uri, null, qnm.getLocalName());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
    }

    protected QNm buildAttributeName(StaticContext ctx, Item name) {
        if (name == null) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
        }
        Atomic atomicName = name.atomize();
        Type nameType = atomicName.type();
        if (nameType.instanceOf(Type.QNM)) {
            return (QNm)name;
        }
        if (nameType.instanceOf(Type.STR) || nameType.instanceOf(Type.UNA)) {
            QNm qnm = new QNm(atomicName.stringValue());
            if (!qnm.getPrefix().isEmpty()) {
                String uri = ctx.getNamespaces().resolve(qnm.getPrefix());
                if (uri == null) {
                    throw new QueryException(ErrorCode.ERR_UNKNOWN_NS_PREFIX_IN_COMP_CONSTR, "Statically unkown namespace prefix in computed element constructor: '%s'", qnm.getPrefix());
                }
                return new QNm(uri, null, qnm.getLocalName());
            }
            String uri = ctx.getNamespaces().getDefaultElementNamespace();
            if (uri == null || uri.isEmpty()) {
                return qnm;
            }
            return new QNm(uri, null, qnm.getLocalName());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
    }

    protected QNm buildPITarget(Item item) {
        QNm target;
        if (item == null) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Empty target in processing instruction");
        }
        Atomic atomic = item.atomize();
        Type type = atomic.type();
        if (type == Type.NCN) {
            target = new QNm(atomic.stringValue());
        } else if (type == Type.STR || type == Type.UNA) {
            String ncname = atomic.stringValue();
            ncname = Whitespace.normalizeXML11(ncname);
            if (!XMLChar.isNCName(ncname = Whitespace.collapse(ncname))) {
                throw new QueryException(ErrorCode.ERR_PI_TARGET_CAST_TO_NCNAME, "Cast target of processing instruction to xs:NCName failed: %s", ncname);
            }
            target = new QNm(ncname);
        } else {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid target in processing instruction");
        }
        if (target.getLocalName().toLowerCase().equals("xml")) {
            throw new QueryException(ErrorCode.ERR_PI_TARGET_IS_XML, "Illegal NCName in processing instruction: '%s'", target);
        }
        return target;
    }

    protected String buildPIContent(Sequence s) {
        String content;
        StringBuilder buf = new StringBuilder();
        if (s != null) {
            if (s instanceof Item) {
                Atomic atomic = ((Item)s).atomize();
                if (!atomic.type().instanceOf(Type.STR)) {
                    atomic = Cast.cast(null, atomic, Type.STR, true);
                }
                buf.append(atomic.stringValue());
            } else {
                boolean first = true;
                try (Iter it = s.iterate();){
                    Item item;
                    while ((item = it.next()) != null) {
                        String str;
                        Atomic atomic = item.atomize();
                        if (!atomic.type().instanceOf(Type.STR)) {
                            atomic = Cast.cast(null, atomic, Type.STR, true);
                        }
                        if ((str = atomic.stringValue()).isEmpty()) continue;
                        if (!first) {
                            buf.append(' ');
                        }
                        first = false;
                        buf.append(str);
                    }
                }
            }
        }
        if ((content = buf.toString()).contains("?>")) {
            throw new QueryException(ErrorCode.ERR_PI_WOULD_CONTAIN_ILLEGAL_STRING, "Content expression of processing instruction illegal string '?>'", content);
        }
        return content;
    }

    protected static interface ContentSink {
        public Node<?> addAttribute(QueryContext var1, Node<?> var2) throws QueryException;

        public Node<?> addNode(QueryContext var1, Node<?> var2) throws QueryException;
    }

    public static final class ContentList
    extends ArrayList<Node<?>>
    implements ContentSink {
        @Override
        public Node<?> addAttribute(QueryContext ctx, Node<?> attribute) {
            this.add(attribute);
            return attribute;
        }

        @Override
        public Node<?> addNode(QueryContext ctx, Node<?> node) {
            this.add(node);
            return node;
        }
    }
}

