/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.Unit;
import io.brackit.query.expr.Variable;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.operator.TupleImpl;
import io.brackit.query.sequence.TypedSequence;
import io.brackit.query.util.ExprUtil;

public class DeclVariable
extends Variable
implements Unit {
    private Expr expr;

    public DeclVariable(QNm name, SequenceType type) {
        super(name, type);
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence s;
        if (ctx.isBound(this.name)) {
            s = ctx.resolve(this.name);
        } else if (this.expr != null) {
            s = this.expr.evaluate(ctx, TupleImpl.EMPTY_TUPLE);
            ctx.bind(this.name, s);
        } else {
            throw new QueryException(ErrorCode.ERR_DYNAMIC_CONTEXT_VARIABLE_NOT_DEFINED, "Variable %s has not been bound", this.name);
        }
        if (this.type != null) {
            s = TypedSequence.toTypedSequence(this.type, s);
        }
        return s;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence res = ctx.resolve(this.name);
        if (res == null) {
            if (this.expr == null) {
                throw new QueryException(ErrorCode.ERR_DYNAMIC_CONTEXT_VARIABLE_NOT_DEFINED, "Variable %s has not been bound", this.name);
            }
            res = this.expr.evaluate(ctx, TupleImpl.EMPTY_TUPLE);
        }
        if (this.type != null) {
            return TypedSequence.toTypedItem(this.type, res);
        }
        return ExprUtil.asItem(res);
    }

    @Override
    public void setExpr(Expr expr) {
        this.expr = expr;
    }
}

