/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.Bits;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.ItemSequence;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.util.ExprUtil;
import java.util.ArrayList;
import java.util.List;

public class DerefDescendantExpr
implements Expr {
    final Expr object;
    final Expr[] fields;

    public DerefDescendantExpr(Expr record, Expr[] fields) {
        this.object = record;
        this.fields = fields;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence sequence = this.object.evaluate(ctx, tuple);
        ArrayList<Item> itemSequence = new ArrayList<Item>();
        for (int index = 0; index < this.fields.length && sequence != null; ++index) {
            Sequence resultSequence = this.processSequence(ctx, tuple, sequence, index);
            Item item = this.getItem(ctx, tuple, index, resultSequence);
            if (item == null) continue;
            itemSequence.add(item);
        }
        if (itemSequence.isEmpty()) {
            return null;
        }
        if (itemSequence.size() == 1) {
            return (Sequence)itemSequence.get(0);
        }
        return new ItemSequence(itemSequence.toArray(new Item[0]));
    }

    private Item getItem(QueryContext ctx, Tuple tuple, int index, Sequence resultSequence) {
        if (resultSequence == null) {
            return null;
        }
        if (resultSequence instanceof Item) {
            Item item = (Item)resultSequence;
            return item;
        }
        try (Iter iter = resultSequence.iterate();){
            Item item = iter.next();
            if (item != null) {
                Sequence currSeq = this.processSequence(ctx, tuple, item, index);
                Item item2 = this.getItem(ctx, tuple, index, currSeq);
                return item2;
            }
        }
        return null;
    }

    private Sequence processSequence(QueryContext ctx, Tuple tuple, Sequence sequence, int index) {
        if (sequence instanceof Array) {
            return this.processArray(ctx, tuple, this.getSequenceValues(ctx, tuple, (Array)sequence, this.fields[index]));
        }
        if (sequence instanceof Object) {
            return this.processObject(sequence, index, ctx, tuple);
        }
        if (sequence instanceof LazySequence) {
            return this.processLazySequence(ctx, tuple, sequence, index);
        }
        if (sequence instanceof ItemSequence) {
            return sequence;
        }
        return null;
    }

    private Sequence processLazySequence(final QueryContext ctx, final Tuple tuple, final Sequence sequence, final int index) {
        return new LazySequence(){

            @Override
            public Iter iterate() {
                final Iter iter = sequence.iterate();
                return new BaseIter(){
                    Iter nestedIter;

                    @Override
                    public Item next() {
                        Item item = null;
                        if (this.nestedIter != null) {
                            item = this.nextItem(this.nestedIter);
                        }
                        if (item == null) {
                            item = this.nextItem(iter);
                        }
                        return item;
                    }

                    private Item nextItem(Iter iter2) {
                        Item item;
                        while ((item = iter2.next()) != null) {
                            if (iter2 == this.nestedIter) {
                                return item;
                            }
                            Sequence resultItem = DerefDescendantExpr.this.processSequence(ctx, tuple, item, index);
                            if (resultItem == null) continue;
                            if (resultItem instanceof LazySequence) {
                                if (this.nestedIter != null) {
                                    this.nestedIter.close();
                                }
                                this.nestedIter = resultItem.iterate();
                                resultItem = this.next();
                                if (resultItem == null) continue;
                            }
                            return resultItem.evaluateToItem(ctx, tuple);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                        if (this.nestedIter != null) {
                            this.nestedIter.close();
                        }
                        iter.close();
                    }
                };
            }
        };
    }

    private Sequence processArray(final QueryContext ctx, final Tuple tuple, final List<Sequence> values) {
        return new LazySequence(this){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    int i;

                    @Override
                    public Item next() {
                        if (this.i < values.size()) {
                            return ((Sequence)values.get(this.i++)).evaluateToItem(ctx, tuple);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    private Sequence processObject(Sequence sequence, int index, QueryContext ctx, Tuple tuple) {
        Object object = (Object)sequence;
        Item field = this.fields[index].evaluateToItem(ctx, tuple);
        if (field == null) {
            return null;
        }
        return this.getSequenceByRecordField(object, field);
    }

    private List<Sequence> getSequenceValues(QueryContext ctx, Tuple t, Array sequence, Expr field1) {
        ArrayList<Sequence> vals = new ArrayList<Sequence>();
        for (Sequence value : sequence.values()) {
            Sequence sequenceByRecordField;
            Sequence val = value.evaluate(ctx, t);
            if (val instanceof Array) {
                vals.addAll(this.getSequenceValues(ctx, t, (Array)val, field1));
                continue;
            }
            if (!(val instanceof Object)) continue;
            Object obj = (Object)val;
            Item field = field1.evaluateToItem(ctx, t);
            if (field == null || (sequenceByRecordField = this.getSequenceByRecordField(obj, field)) == null) continue;
            vals.add(sequenceByRecordField);
        }
        return vals;
    }

    private Sequence getSequenceByRecordField(Object record, Item field) {
        Sequence sequence;
        if (field instanceof QNm) {
            sequence = record.get((QNm)field);
        } else if (field instanceof IntNumeric) {
            sequence = record.value((IntNumeric)field);
        } else if (field instanceof Atomic) {
            sequence = record.get(new QNm(((Atomic)field).asStr().toString()));
        } else {
            throw new QueryException(Bits.BIT_ILLEGAL_OBJECT_FIELD, "Illegal record field reference: %s", field);
        }
        return sequence;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        if (this.object.isUpdating()) {
            return true;
        }
        for (Expr field : this.fields) {
            if (!field.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Expr f : this.fields) {
            s.append("==>");
            s.append(f);
        }
        return s.toString();
    }
}

