/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Bool;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.sequence.TypedSequence;

public class InstanceOf
implements Expr {
    private final Expr expr;
    private final SequenceType expected;

    public InstanceOf(Expr expr, SequenceType expected) {
        this.expr = expr;
        this.expected = expected;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        try {
            Sequence sequence = this.expr.evaluate(ctx, tuple);
            if (sequence instanceof Item) {
                TypedSequence.toTypedItem(this.expected, (Item)sequence);
            } else {
                Sequence typed = TypedSequence.toTypedSequence(this.expected, sequence);
                if (typed != null) {
                    try (Iter it = typed.iterate();){
                        while (it.next() != null) {
                        }
                    }
                }
            }
            return Bool.TRUE;
        }
        catch (QueryException e) {
            if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                return Bool.FALSE;
            }
            throw e;
        }
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

