/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Bool;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;

public class NodeCmpExpr
implements Expr {
    protected final NodeCmp nodeCmp;
    protected final Expr leftExpr;
    protected final Expr rightExpr;

    public NodeCmpExpr(NodeCmp nodeCmp, Expr leftExpr, Expr rightExpr) {
        this.nodeCmp = nodeCmp;
        this.leftExpr = leftExpr;
        this.rightExpr = rightExpr;
    }

    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Item left = this.leftExpr.evaluateToItem(ctx, tuple);
        Item right = this.rightExpr.evaluateToItem(ctx, tuple);
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Left argument is not a node: %s", left);
        }
        if (!(right instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "right argument is not a node: %s", right);
        }
        return this.nodeCmp.compare(ctx, (Node)left, (Node)right);
    }

    @Override
    public boolean isUpdating() {
        return this.leftExpr.isUpdating() || this.rightExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public static enum NodeCmp {
        Is{

            @Override
            public Bool compare(QueryContext ctx, Node<?> left, Node<?> right) {
                return left.equals(right) ? Bool.TRUE : Bool.FALSE;
            }
        }
        ,
        Preceding{

            @Override
            public Bool compare(QueryContext ctx, Node<?> left, Node<?> right) {
                return left.isPrecedingOf(right) ? Bool.TRUE : Bool.FALSE;
            }
        }
        ,
        Following{

            @Override
            public Bool compare(QueryContext ctx, Node<?> left, Node<?> right) {
                return left.isFollowingOf(right) ? Bool.TRUE : Bool.FALSE;
            }
        };


        public abstract Bool compare(QueryContext var1, Node<?> var2, Node<?> var3) throws QueryException;
    }
}

