/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.ErrorCode;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.Bits;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jsonitem.object.ArrayObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class ObjectExpr
implements Expr {
    final Field[] fields;

    public ObjectExpr(Field[] fields) {
        this.fields = fields;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) {
        return this.evaluateToItem(ctx, t);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple t) {
        HashSet<QNm> dedup = new HashSet<QNm>();
        QNm[] names = new QNm[this.fields.length];
        Sequence[] vals = new Sequence[this.fields.length];
        int pos = 0;
        for (Field field : this.fields) {
            io.brackit.query.jdm.json.Object res = field.evaluate(ctx, t);
            for (int j = 0; j < res.len(); ++j) {
                QNm name = res.name(j);
                if (!dedup.add(name)) {
                    throw new QueryException(Bits.BIT_DUPLICATE_OBJECT_FIELD, "Duplicate field name: %s", name);
                }
                Sequence val = res.value(j);
                if (pos == names.length) {
                    names = Arrays.copyOfRange(names, 0, names.length * 3 / 2 + 1);
                    vals = Arrays.copyOfRange(vals, 0, vals.length * 3 / 2 + 1);
                }
                names[pos] = name;
                vals[pos] = val;
                ++pos;
            }
        }
        if (pos < names.length) {
            names = Arrays.copyOfRange(names, 0, pos);
            vals = Arrays.copyOfRange(vals, 0, pos);
        }
        return new ArrayObject(names, vals);
    }

    @Override
    public boolean isUpdating() {
        for (Field e : this.fields) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        for (Field e : this.fields) {
            if (e.isVacuous()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        boolean first = true;
        for (Field field : this.fields) {
            if (!first) {
                out.append(", ");
            }
            first = false;
            out.append(field.toString());
        }
        out.append("]");
        return out.toString();
    }

    public static void main(String[] args) {
        new Query("{ a:1, b:2, c:3 , {x:1}, y:5, z : {foo : 'bar'}, 'aha' : 2, 'h h' : 5 }").serialize((QueryContext)new BrackitQueryContext(), System.out);
    }

    public static abstract class Field {
        abstract io.brackit.query.jdm.json.Object evaluate(QueryContext var1, Tuple var2) throws QueryException;

        abstract boolean isUpdating();

        boolean isVacuous() {
            return false;
        }
    }

    public static class KeyValueField
    extends Field {
        final Expr nameExpr;
        final Expr valueExpr;

        public KeyValueField(Expr name, Expr expr) {
            this.nameExpr = name;
            this.valueExpr = expr;
        }

        @Override
        public io.brackit.query.jdm.json.Object evaluate(QueryContext ctx, Tuple t) {
            Item names = this.nameExpr.evaluateToItem(ctx, t);
            Item val = this.valueExpr.evaluateToItem(ctx, t);
            if (names instanceof Str) {
                return new ArrayObject(new QNm[]{new QNm(((Str)names).stringValue())}, new Sequence[]{val});
            }
            return new ArrayObject(new QNm[]{(QNm)names.get(0)}, new Sequence[]{val});
        }

        @Override
        boolean isUpdating() {
            return this.valueExpr.isUpdating();
        }
    }

    public static class ObjectField
    extends Field {
        final Expr expr;

        public ObjectField(Expr expr) {
            this.expr = expr;
        }

        @Override
        public io.brackit.query.jdm.json.Object evaluate(QueryContext ctx, Tuple t) {
            Sequence i = this.expr.evaluate(ctx, t);
            if (i instanceof io.brackit.query.jdm.json.Object) {
                return (io.brackit.query.jdm.json.Object)i;
            }
            ArrayList names = new ArrayList();
            ArrayList values = new ArrayList();
            try (Iter iter = i.iterate();){
                Item item;
                while ((item = iter.next()) != null) {
                    if (!(item instanceof io.brackit.query.jdm.json.Object)) {
                        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal item type in object constructor: %s", item.itemType());
                    }
                    io.brackit.query.jdm.json.Object object = (io.brackit.query.jdm.json.Object)item;
                    Collections.addAll(names, object.names().values().toArray(new QNm[0]));
                    Collections.addAll(values, object.values().values().toArray(new Sequence[0]));
                }
            }
            return new ArrayObject(names.toArray(new QNm[0]), values.toArray(new Sequence[0]));
        }

        @Override
        boolean isUpdating() {
            return this.expr.isUpdating();
        }
    }
}

