/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.expr.ConstructedNodeBuilder;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;

public class PIExpr
extends ConstructedNodeBuilder
implements Expr {
    protected final QNm name;
    protected final Expr nameExpr;
    protected final Expr contentExpr;
    protected final boolean appendOnly;

    public PIExpr(Expr nameExpr, Expr contentExpr, boolean appendOnly) {
        this.nameExpr = nameExpr;
        this.contentExpr = contentExpr;
        this.appendOnly = appendOnly;
        this.name = (QNm)(nameExpr instanceof QNm ? nameExpr : null);
    }

    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        QNm target = this.name != null ? this.name : this.buildPITarget(this.nameExpr.evaluateToItem(ctx, tuple));
        Sequence sequence = this.contentExpr.evaluate(ctx, tuple);
        String content = this.buildPIContent(sequence);
        if (this.appendOnly) {
            ((Node)tuple.get(tuple.getSize() - 1)).append(Kind.PROCESSING_INSTRUCTION, target, new Str(content));
            return null;
        }
        Object attribute = ctx.getNodeFactory().pi(target, new Str(content));
        return attribute;
    }

    @Override
    public boolean isUpdating() {
        return this.nameExpr.isUpdating() || this.contentExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

