/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;

public class PrintExpr
implements Expr {
    private static int maxSize = 20;

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        String str = PrintExpr.asString(tuple);
        return new Str(str);
    }

    public static String asString(Tuple tuple) throws QueryException {
        StringBuilder out = new StringBuilder();
        int size = tuple.getSize();
        out.append("|");
        for (int i = 0; i < size; ++i) {
            out.append(' ');
            Sequence s = tuple.get(i);
            String str = s != null ? s.toString() : "()";
            str = PrintExpr.shrinkOrPad(str);
            out.append(str);
            out.append(" |");
        }
        String str = out.toString();
        return str;
    }

    private static String shrinkOrPad(String s) {
        int length = s.length();
        if (length == maxSize) {
            return s;
        }
        if (length > maxSize) {
            return s.substring(0, maxSize);
        }
        int toAdd = maxSize - length;
        char[] result = new char[maxSize];
        int i = 0;
        while (i < toAdd / 2) {
            result[i++] = 32;
        }
        System.arraycopy(s.toCharArray(), 0, result, i, length);
        int j = i + length;
        while (i++ < toAdd) {
            result[j++] = 32;
        }
        return new String(result);
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

