/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.sequence.AbstractSequence;
import io.brackit.query.sequence.BaseIter;

public class RangeExpr
implements Expr {
    protected final Expr leftExpr;
    protected final Expr rightExpr;

    public RangeExpr(Expr leftExpr, Expr rightExpr) {
        this.leftExpr = leftExpr;
        this.rightExpr = rightExpr;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        int comparison;
        Item lItem = this.leftExpr.evaluateToItem(ctx, tuple);
        Item rItem = this.rightExpr.evaluateToItem(ctx, tuple);
        if (lItem == null || rItem == null) {
            return null;
        }
        Atomic left = lItem.atomize();
        Atomic right = rItem.atomize();
        if (!(left instanceof IntNumeric)) {
            left = this.convert(left);
        }
        if (!(right instanceof IntNumeric)) {
            right = this.convert(right);
        }
        if ((comparison = left.cmp(right)) > 0) {
            return null;
        }
        if (comparison == 0) {
            return left;
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE);
    }

    protected Atomic convert(Atomic val) {
        if (val.type() != Type.UNA) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", val.type(), Type.INR);
        }
        val = Cast.cast(null, val, Type.INR, false);
        return val;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        int comparison;
        Item lItem = this.leftExpr.evaluateToItem(ctx, tuple);
        Item rItem = this.rightExpr.evaluateToItem(ctx, tuple);
        if (lItem == null || rItem == null) {
            return null;
        }
        Atomic left = lItem.atomize();
        Atomic right = rItem.atomize();
        if (!(left instanceof IntNumeric)) {
            left = this.convert(left);
        }
        if (!(right instanceof IntNumeric)) {
            right = this.convert(right);
        }
        if ((comparison = left.cmp(right)) > 0) {
            return null;
        }
        if (comparison == 0) {
            return left;
        }
        final IntNumeric s = (IntNumeric)left;
        final IntNumeric e = (IntNumeric)right;
        return new AbstractSequence(this){
            private final IntNumeric start;
            private final IntNumeric end;
            {
                this.start = s;
                this.end = e;
            }

            @Override
            public boolean booleanValue() {
                if (!this.size().eq(Int32.ONE)) {
                    throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value is undefined for sequences with two or more items not starting with a node");
                }
                return this.start.booleanValue();
            }

            @Override
            public IntNumeric size() {
                return (IntNumeric)this.end.subtract(this.start).add(Int32.ONE);
            }

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    IntNumeric current;
                    {
                        this.current = start;
                    }

                    @Override
                    public void close() {
                    }

                    @Override
                    public Item next() {
                        if (this.current.cmp(e) > 0) {
                            return null;
                        }
                        IntNumeric res = this.current;
                        this.current = this.current.inc();
                        return res;
                    }

                    @Override
                    public void skip(IntNumeric i) {
                        if (i.cmp(Int32.ZERO) <= 0) {
                            return;
                        }
                        this.current = (IntNumeric)this.current.add(i);
                    }
                };
            }

            @Override
            public Item get(IntNumeric pos) {
                if (Int32.ZERO.cmp(pos) >= 0) {
                    return null;
                }
                if (this.size().cmp(pos) < 0) {
                    return null;
                }
                return this.start.add(pos).subtract(Int32.ONE);
            }
        };
    }

    @Override
    public boolean isUpdating() {
        return this.leftExpr.isUpdating() || this.rightExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return "(" + String.valueOf(this.leftExpr) + " to " + String.valueOf(this.rightExpr) + ")";
    }
}

