/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.expr;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.ExprUtil;

public class TryCatchExpr
implements Expr {
    final Expr expr;
    final ErrorCatch[][] catches;
    final Expr[] handler;
    final boolean bindCode;
    final boolean bindDesc;
    final boolean bindValue;
    final boolean bindModule;
    final boolean bindLineNo;
    final boolean bindColNo;
    final int bindCount;

    public TryCatchExpr(Expr expr, ErrorCatch[][] catches, Expr[] handler, boolean bindCode, boolean bindDesc, boolean bindValue, boolean bindModule, boolean bindLineNo, boolean bindColNo) {
        this.expr = expr;
        this.catches = catches;
        this.handler = handler;
        this.bindCode = bindCode;
        this.bindDesc = bindDesc;
        this.bindValue = bindValue;
        this.bindModule = bindModule;
        this.bindLineNo = bindLineNo;
        this.bindColNo = bindColNo;
        int bindCount = 0;
        if (bindCode) {
            ++bindCount;
        }
        if (bindDesc) {
            ++bindCount;
        }
        if (bindValue) {
            ++bindCount;
        }
        if (bindModule) {
            ++bindCount;
        }
        if (bindLineNo) {
            ++bindCount;
        }
        if (bindColNo) {
            ++bindCount;
        }
        this.bindCount = bindCount;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        try {
            return this.expr.evaluate(ctx, tuple);
        }
        catch (QueryException e) {
            for (int i = 0; i < this.catches.length; ++i) {
                if (this.catches[i].length == 0) {
                    Tuple t = this.bindInfo(tuple, e);
                    return this.handler[i].evaluate(ctx, t);
                }
                for (int j = 0; j < this.catches[i].length; ++j) {
                    if (!this.catches[i][j].matches(e.getCode())) continue;
                    Tuple t = this.bindInfo(tuple, e);
                    return this.handler[i].evaluate(ctx, t);
                }
            }
            throw e;
        }
    }

    private Tuple bindInfo(Tuple tuple, QueryException e) {
        Sequence[] info = new Sequence[this.bindCount];
        int pos = 0;
        if (this.bindCode) {
            info[pos++] = e.getCode();
        }
        if (this.bindDesc) {
            info[pos++] = new Str(e.getMessage());
        }
        if (this.bindValue) {
            info[pos++] = null;
        }
        if (this.bindModule) {
            info[pos++] = null;
        }
        if (this.bindLineNo) {
            info[pos++] = null;
        }
        if (this.bindColNo) {
            info[pos] = null;
        }
        return tuple.concat(info);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        if (this.expr.isUpdating()) {
            return true;
        }
        for (Expr h : this.handler) {
            if (!h.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public static interface ErrorCatch {
        public boolean matches(QNm var1);
    }

    public static class Name
    implements ErrorCatch {
        final String localname;
        final String nsURI;

        public Name(String localname, String nsURI) {
            this.localname = localname;
            this.nsURI = nsURI;
        }

        @Override
        public boolean matches(QNm qname) {
            return this.localname.equals(qname.getLocalName()) && this.nsURI.equals(qname.getNamespaceURI());
        }
    }

    public static class NSWildcard
    implements ErrorCatch {
        final String localname;

        public NSWildcard(String localname) {
            this.localname = localname;
        }

        @Override
        public boolean matches(QNm qname) {
            return this.localname.equals(qname.getLocalName());
        }
    }

    public static class NameWildcard
    implements ErrorCatch {
        final String nsURI;

        public NameWildcard(String nsURI) {
            this.nsURI = nsURI;
        }

        @Override
        public boolean matches(QNm qname) {
            return this.nsURI.equals(qname.getNamespaceURI());
        }
    }

    public static class Wildcard
    implements ErrorCatch {
        @Override
        public boolean matches(QNm qname) {
            return true;
        }
    }
}

