/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.AbstractItem;
import io.brackit.query.jdm.Function;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.FunctionType;
import io.brackit.query.jdm.type.ItemType;

public abstract class AbstractFunction
extends AbstractItem
implements Function {
    private final QNm name;
    private final Signature signature;
    private final boolean isUpdating;
    private final boolean isBuiltIn;

    public AbstractFunction(QNm name, Signature signature, boolean isBuiltIn) {
        this.name = name;
        this.signature = signature;
        this.isUpdating = false;
        this.isBuiltIn = isBuiltIn;
    }

    public AbstractFunction(QNm name, Signature signature, boolean isBuiltIn, boolean isUpating) {
        this.name = name;
        this.signature = signature;
        this.isUpdating = isUpating;
        this.isBuiltIn = isBuiltIn;
    }

    @Override
    public final QNm getName() {
        return this.name;
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isUpdating() {
        return this.isUpdating;
    }

    @Override
    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public final String toString() {
        return this.name == null ? String.valueOf(this.signature) : this.name.toString() + String.valueOf(this.signature);
    }

    @Override
    public Atomic atomize() throws QueryException {
        throw new QueryException(ErrorCode.ERR_ITEM_HAS_NO_TYPED_VALUE, "The atomized value of function items is undefined");
    }

    @Override
    public ItemType itemType() throws QueryException {
        return new FunctionType(this.signature);
    }

    @Override
    public boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "The effective boolean value of function items is undefined");
    }
}

