/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Function;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.sequence.FunctionConversionSequence;
import io.brackit.query.util.ExprUtil;

public class FunctionExpr
implements Expr {
    private final StaticContext sctx;
    private final Function function;
    private final Expr[] exprs;
    private final boolean builtin;
    private final SequenceType dftCtxType;

    public FunctionExpr(StaticContext sctx, Function function, Expr ... exprs) throws QueryException {
        this.sctx = sctx;
        this.function = function;
        this.exprs = exprs;
        this.builtin = function.isBuiltIn();
        ItemType dftCtxItemType = function.getSignature().defaultCtxItemType();
        this.dftCtxType = dftCtxItemType != null ? new SequenceType(dftCtxItemType, Cardinality.One) : null;
    }

    public Signature getSignature() {
        return this.function.getSignature();
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        Sequence res;
        Sequence[] args;
        if (this.dftCtxType != null) {
            Item ctxItem = this.exprs[0].evaluateToItem(ctx, tuple);
            FunctionConversionSequence.asTypedSequence(this.dftCtxType, ctxItem, this.builtin);
            args = new Sequence[]{ctxItem};
        } else {
            SequenceType[] params = this.function.getSignature().getParams();
            args = new Sequence[this.exprs.length];
            for (int i = 0; i < this.exprs.length; ++i) {
                SequenceType sType;
                SequenceType sequenceType = sType = i < params.length ? params[i] : params[params.length - 1];
                if (sType.getCardinality().many()) {
                    args[i] = this.exprs[i].evaluate(ctx, tuple);
                    if (sType.getItemType().isAnyItem()) continue;
                    args[i] = FunctionConversionSequence.asTypedSequence(sType, args[i], this.builtin);
                    continue;
                }
                args[i] = this.exprs[i].evaluateToItem(ctx, tuple);
                args[i] = FunctionConversionSequence.asTypedSequence(sType, args[i], this.builtin);
            }
        }
        try {
            res = this.function.execute(this.sctx, ctx, args);
        }
        catch (StackOverflowError e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_RT_STACK_OVERFLOW, "Execution of function '%s' was aborted because of too deep recursion.", this.function.getName());
        }
        if (this.function.isBuiltIn()) {
            return res;
        }
        res = FunctionConversionSequence.asTypedSequence(this.function.getSignature().getResultType(), res, this.builtin);
        return ExprUtil.materialize(res);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        return this.function.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return this.function.toString();
    }
}

