/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.Query;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.bit.BitFun;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.annotation.FunctionAnnotation;
import io.brackit.query.util.io.IOUtils;
import io.brackit.query.util.serialize.StringSerializer;
import java.io.PrintStream;

@FunctionAnnotation(description="Executes the given query.", parameters={"$query"})
public class Eval
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "eval");

    public Eval() {
        this(DEFAULT_NAME);
    }

    public Eval(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AnyItemType.ANY, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            String vQuery = null;
            if (args[0] instanceof Atomic) {
                vQuery = ((Atomic)args[0]).stringValue();
            } else {
                PrintStream buf = IOUtils.createBuffer();
                try (StringSerializer ser = new StringSerializer(buf);){
                    ser.serialize(args[0]);
                }
                vQuery = buf.toString();
            }
            Query x = new Query(vQuery);
            return x.execute(new BrackitQueryContext(ctx.getNodeStore()));
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_EVAL_INT_ERROR, (Object)e.getMessage());
        }
    }
}

