/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.bit.BitFun;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.annotation.FunctionAnnotation;

@FunctionAnnotation(description="Checks whether a collection exists or not.", parameters={"$name"})
public class Exists
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "exists");

    public Exists() {
        this(DEFAULT_NAME);
    }

    public Exists(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            String name = ((Atomic)args[0]).stringValue();
            return ctx.getNodeStore().lookup(name) != null ? Bool.TRUE : Bool.FALSE;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_EXISTCOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }
}

