/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.bit.BitFun;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.StructuredItemCollection;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.jdm.node.NodeStore;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ElementType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.node.parser.DocumentParser;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.util.annotation.FunctionAnnotation;
import io.brackit.query.util.io.URIHandler;
import java.io.IOException;

@FunctionAnnotation(description="Load (external) documents into a collection. If explicitly required or if the collection does not exist, a new collection will be created. ", parameters={"$name", "$resources", "$create-new"})
public class Load
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "load");

    public Load(boolean createNew) {
        this(DEFAULT_NAME, createNew);
    }

    public Load(QNm name, boolean createNew) {
        super(name, createNew ? new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany)) : new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.BOOL, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            boolean createNew = args.length != 3 || args[2].booleanValue();
            String name = ((Atomic)args[0]).stringValue();
            Sequence resources = args[1];
            NodeStore s = ctx.getNodeStore();
            if (createNew) {
                this.create(s, name, resources);
            } else {
                try {
                    StructuredItemCollection coll = s.lookup(name);
                    this.add(s, (NodeCollection<?>)coll, resources);
                }
                catch (DocumentException e) {
                    this.create(s, name, resources);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_ADDTOCOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }

    private void add(NodeStore store, NodeCollection<?> coll, Sequence resources) throws DocumentException, IOException {
        if (resources instanceof Atomic) {
            String r = ((Atomic)resources).stringValue();
            coll.add(new DocumentParser(URIHandler.getInputStream(r)));
        } else {
            try (ParserStream parsers = new ParserStream(resources);){
                NodeSubtreeParser parser;
                while ((parser = parsers.next()) != null) {
                    coll.add(parser);
                }
            }
        }
    }

    private void create(NodeStore store, String name, Sequence resources) throws DocumentException, IOException {
        if (resources instanceof Atomic) {
            String r = ((Atomic)resources).stringValue();
            store.create(name, new DocumentParser(URIHandler.getInputStream(r)));
        } else {
            store.create(name, new ParserStream(resources));
        }
    }

    private static class ParserStream
    implements Stream<NodeSubtreeParser> {
        Iter it;

        public ParserStream(Sequence locs) {
            this.it = locs.iterate();
        }

        @Override
        public NodeSubtreeParser next() throws DocumentException {
            try {
                Item i = this.it.next();
                if (i == null) {
                    return null;
                }
                if (i instanceof Atomic) {
                    String s = ((Atomic)i).stringValue();
                    return new DocumentParser(URIHandler.getInputStream(s));
                }
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot create subtree parser for item of type: %s", i.itemType());
            }
            catch (QueryException | IOException e) {
                throw new DocumentException(e);
            }
        }

        @Override
        public void close() {
            this.it.close();
        }
    }
}

