/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AbstractTimeInstant;
import io.brackit.query.atomic.Int64;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.annotation.FunctionAnnotation;
import java.util.Calendar;
import java.util.TimeZone;

@FunctionAnnotation(description="Returns the milliseconds since 1970/01/01.", parameters={""})
public class Now
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "now");

    public Now() {
        this(DEFAULT_NAME);
    }

    public Now(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.INT, Cardinality.One), new SequenceType[0]), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            AbstractTimeInstant dateTime = ctx.getDateTime().canonicalize();
            int millis = dateTime.getMicros() % 1000000 / 1000;
            int seconds = dateTime.getMicros() / 1000000;
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.set(1, dateTime.getYear());
            cal.set(2, dateTime.getMonth() - 1);
            cal.set(11, dateTime.getHours());
            cal.set(12, dateTime.getMinutes());
            cal.set(13, seconds);
            cal.set(14, millis);
            long currentMillis = cal.getTimeInMillis();
            return new Int64(currentMillis);
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
    }
}

