/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.util.io.IOUtils;
import io.brackit.query.util.serialize.StringSerializer;
import java.io.PrintStream;

public class Serialize
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "serialize");

    public Serialize() {
        this(DEFAULT_NAME);
    }

    public Serialize(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), SequenceType.ITEM_SEQUENCE), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Sequence sequence = args[0];
        if (sequence == null) {
            return Int32.ZERO;
        }
        PrintStream buf = IOUtils.createBuffer();
        try (StringSerializer serializer = new StringSerializer(buf);){
            serializer.serialize(sequence);
        }
        return new Str(buf.toString());
    }
}

