/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.bit;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.bit.BitFun;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.StructuredItemCollection;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.jdm.node.NodeStore;
import io.brackit.query.jdm.type.AnyNodeType;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ElementType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.node.parser.NodeStreamSubtreeParser;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.util.annotation.FunctionAnnotation;

@FunctionAnnotation(description="Store the given fragments in a collection. If explicitly required or if the collection does not exist, a new collection will be created. ", parameters={"$name", "$fragments", "$create-new"})
public class Store
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "store");

    public Store(boolean createNew) {
        this(DEFAULT_NAME, createNew);
    }

    public Store(QNm name, boolean createNew) {
        super(name, createNew ? new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrMany)) : new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrMany), new SequenceType(AtomicType.BOOL, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            boolean createNew = args.length != 3 || args[2].booleanValue();
            String name = ((Atomic)args[0]).stringValue();
            Sequence nodes = args[1];
            NodeStore s = ctx.getNodeStore();
            if (createNew) {
                this.create(s, name, nodes);
            } else {
                try {
                    StructuredItemCollection coll = s.lookup(name);
                    this.add((NodeCollection<?>)coll, nodes);
                }
                catch (DocumentException e) {
                    this.create(s, name, nodes);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_ADDTOCOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }

    private void add(NodeCollection<?> coll, Sequence nodes) throws DocumentException {
        if (nodes instanceof Node) {
            Node n = (Node)nodes;
            coll.add(new NodeStoreParser(n));
        } else {
            try (ParserStream parsers = new ParserStream(nodes);){
                NodeSubtreeParser parser;
                while ((parser = parsers.next()) != null) {
                    coll.add(parser);
                }
            }
        }
    }

    private void create(NodeStore store, String name, Sequence nodes) throws DocumentException {
        if (nodes instanceof Node) {
            Node n = (Node)nodes;
            store.create(name, new NodeStoreParser(n));
        } else {
            store.create(name, new ParserStream(nodes));
        }
    }

    private static class NodeStoreParser
    implements NodeSubtreeParser {
        private final NodeStreamSubtreeParser parser;
        private final boolean intercept;

        public NodeStoreParser(Node<?> node) throws DocumentException {
            this.parser = new NodeStreamSubtreeParser(node.getSubtree());
            this.intercept = node.getKind() != Kind.DOCUMENT;
        }

        @Override
        public void parse(NodeSubtreeHandler handler) throws DocumentException {
            if (this.intercept) {
                handler = new InterceptorHandler(handler);
            }
            this.parser.parse(handler);
        }
    }

    private static class ParserStream
    implements Stream<NodeSubtreeParser> {
        Iter it;

        public ParserStream(Sequence locs) {
            this.it = locs.iterate();
        }

        @Override
        public NodeSubtreeParser next() throws DocumentException {
            try {
                Item i = this.it.next();
                if (i == null) {
                    return null;
                }
                if (i instanceof Node) {
                    Node n = (Node)i;
                    return new NodeStoreParser(n);
                }
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot create subtree parser for item of type: %s", i.itemType());
            }
            catch (QueryException e) {
                throw new DocumentException(e);
            }
        }

        @Override
        public void close() {
            this.it.close();
        }
    }

    private static class InterceptorHandler
    implements NodeSubtreeHandler {
        private final NodeSubtreeHandler handler;

        public InterceptorHandler(NodeSubtreeHandler handler) {
            this.handler = handler;
        }

        @Override
        public void beginFragment() throws DocumentException {
            this.handler.beginFragment();
            this.handler.startDocument();
        }

        @Override
        public void endFragment() throws DocumentException {
            this.handler.endDocument();
            this.handler.endFragment();
        }

        @Override
        public void startDocument() throws DocumentException {
            this.handler.startDocument();
        }

        @Override
        public void endDocument() throws DocumentException {
            this.handler.endDocument();
        }

        @Override
        public void text(Atomic content) throws DocumentException {
            this.handler.text(content);
        }

        @Override
        public void comment(Atomic content) throws DocumentException {
            this.handler.comment(content);
        }

        @Override
        public void processingInstruction(QNm target, Atomic content) throws DocumentException {
            this.handler.processingInstruction(target, content);
        }

        @Override
        public void startMapping(String prefix, String uri) throws DocumentException {
            this.handler.startMapping(prefix, uri);
        }

        @Override
        public void endMapping(String prefix) throws DocumentException {
            this.handler.endMapping(prefix);
        }

        @Override
        public void startElement(QNm name) throws DocumentException {
            this.handler.startElement(name);
        }

        @Override
        public void endElement(QNm name) throws DocumentException {
            this.handler.endElement(name);
        }

        @Override
        public void attribute(QNm name, Atomic value) throws DocumentException {
            this.handler.attribute(name, value);
        }

        @Override
        public void begin() throws DocumentException {
            this.handler.begin();
        }

        @Override
        public void end() throws DocumentException {
            this.handler.end();
        }

        @Override
        public void fail() throws DocumentException {
            this.handler.fail();
        }
    }
}

