/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.module.StaticContext;

public class CardinalityTest
extends AbstractFunction {
    private final Cardinality cardinality;

    public CardinalityTest(QNm name, Signature signature, Cardinality cardinality) {
        super(name, signature, true);
        this.cardinality = cardinality;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (this.cardinality == Cardinality.One) {
            return this.exactlyOnce(args);
        }
        if (this.cardinality == Cardinality.OneOrMany) {
            return this.oneOrMore(args);
        }
        if (this.cardinality == Cardinality.ZeroOrOne) {
            return this.zeroOrOne(args);
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unsupported cardinality test: %s", new Object[]{this.cardinality});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence zeroOrOne(Sequence[] args) throws QueryException {
        Sequence s = args[0];
        if (s != null && !(s instanceof Item)) {
            try (Iter it = s.iterate();){
                s = it.next();
                if (s != null && it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_ZERO_OR_ONE_FAILED, "fn:zero-or-one called with a sequence containing more than one item");
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence oneOrMore(Sequence[] args) throws QueryException {
        Sequence s = args[0];
        if (s == null) {
            throw new QueryException(ErrorCode.ERR_ONE_OR_MORE_FAILED, "fn:one-or-more called with an empty sequence");
        }
        if (!(s instanceof Item)) {
            try (Iter it = s.iterate();){
                if (it.next() == null) {
                    throw new QueryException(ErrorCode.ERR_ONE_OR_MORE_FAILED, "fn:one-or-more called with an empty sequence");
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence exactlyOnce(Sequence[] args) throws QueryException {
        Sequence s = args[0];
        if (s == null) {
            throw new QueryException(ErrorCode.ERR_EXACTLY_ONCE_FAILED, "fn:exactly-one called with an empty sequence");
        }
        if (!(s instanceof Item)) {
            try (Iter it = s.iterate();){
                s = it.next();
                if (s == null) {
                    throw new QueryException(ErrorCode.ERR_EXACTLY_ONCE_FAILED, "fn:exactly-one called with an empty sequence");
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_EXACTLY_ONCE_FAILED, "fn:exactly-one called with a sequence containing more than one item");
                }
            }
        }
        return s;
    }
}

