/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.module.StaticContext;

public class Root
extends AbstractFunction {
    public Root(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Item item = (Item)args[0];
        if (item == null) {
            return null;
        }
        if (!(item instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Context item is not a node: %s", item);
        }
        Node root = (Node)item;
        try {
            Object parent;
            while ((parent = root.getParent()) != null) {
                root = parent;
            }
        }
        catch (DocumentException e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_DOCUMENT_ACCESS_ERROR);
        }
        return root;
    }
}

