/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.fn;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.module.StaticContext;

public class StringTranslate
extends AbstractFunction {
    public StringTranslate(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return Str.EMPTY;
        }
        String str = ((Str)args[0]).stringValue();
        String map = ((Str)args[1]).stringValue();
        String trans = ((Str)args[2]).stringValue();
        StringBuilder sb = new StringBuilder(str.length());
        if (map.isEmpty()) {
            return Str.EMPTY;
        }
        int copy = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int index = map.indexOf(c);
            if (index == -1 || index >= trans.length()) continue;
            if (copy < i) {
                sb.append(str.substring(copy, i));
            }
            sb.append(trans.charAt(index));
            copy = i + 1;
        }
        if (copy < str.length()) {
            sb.append(str.substring(copy));
        }
        return new Str(sb.toString());
    }
}

