/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.io;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.io.IOFun;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.util.io.URIHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Readline
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/io", "io", "readline");

    public Readline() {
        this(DEFAULT_NAME);
    }

    public Readline(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        final String uri = ((Atomic)args[0]).stringValue();
        return new LazySequence(this){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    BufferedReader in;

                    @Override
                    public Item next() throws QueryException {
                        try {
                            String line;
                            if (this.in == null) {
                                this.in = new BufferedReader(new InputStreamReader(URIHandler.getInputStream(uri)));
                            }
                            return (line = this.in.readLine()) != null ? new Str(line) : null;
                        }
                        catch (Exception e) {
                            throw new QueryException(e, IOFun.IO_LOADFILE_INT_ERROR);
                        }
                    }

                    @Override
                    public void close() {
                        if (this.in != null) {
                            try {
                                this.in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
        };
    }
}

