/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.json;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.AnyURI;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.function.json.Doc;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.json.JsonCollection;
import io.brackit.query.module.StaticContext;

public final class Collection
extends AbstractFunction {
    public Collection(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        String name = args.length > 0 ? ((Str)args[0]).stringValue() : null;
        try {
            if (name == null || name.isEmpty()) {
                JsonCollection<?> collection = ctx.getDefaultJsonCollection();
                if (collection == null) {
                    throw new QueryException(ErrorCode.ERR_COLLECTION_NOT_FOUND, "No default collection defined.");
                }
                return collection;
            }
            AnyURI uri = Doc.resolve(sctx, name);
            return ctx.getJsonItemStore().lookup(uri.stringValue());
        }
        catch (DocumentException e) {
            throw new QueryException(e, ErrorCode.ERR_COLLECTION_NOT_FOUND, "Collection '%s' not found.", name);
        }
    }
}

