/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.json;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Dec;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.Null;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.parser.Tokenizer;
import io.brackit.query.function.json.JSONFun;
import io.brackit.query.jdm.Item;
import io.brackit.query.jsonitem.array.DArray;
import io.brackit.query.jsonitem.object.ArrayObject;
import io.brackit.query.util.serialize.StringSerializer;
import java.util.ArrayList;
import java.util.List;

public final class JSONParser
extends Tokenizer {
    public JSONParser(String query) {
        super(query);
    }

    public Item parse() throws QueryException {
        try {
            Item i = this.object();
            Item item = i = i != null ? i : this.array();
            if (i == null && (i = this.value(true)) == null) {
                throw new QueryException(JSONFun.ERR_PARSING_ERROR, "No JSON data found");
            }
            this.consumeEOF();
            return i;
        }
        catch (Exception e) {
            throw new QueryException(e, JSONFun.ERR_PARSING_ERROR, (Object)e.getMessage());
        }
    }

    protected void consumeSkipS(String token) throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipS(token);
        if (la == null) {
            throw (Tokenizer)this.new Tokenizer.TokenizerException("Expected '%s': '%s'", token, this.paraphrase());
        }
        this.consume(la);
    }

    private Item value(boolean required) throws Tokenizer.TokenizerException, QueryException {
        Str i = this.string();
        i = i != null ? i : this.number();
        i = i != null ? i : this.object();
        i = i != null ? i : this.array();
        i = i != null ? i : this.symbol(required);
        return i;
    }

    private Item symbol(boolean required) throws Tokenizer.TokenizerException {
        if (this.attemptSkipS("true")) {
            return Bool.TRUE;
        }
        if (this.attemptSkipS("false")) {
            return Bool.FALSE;
        }
        if (this.attemptSkipS("null")) {
            return new Null();
        }
        if (required) {
            throw (Tokenizer)this.new Tokenizer.TokenizerException("JSON value expected: %s", this.paraphrase());
        }
        return null;
    }

    private Item array() throws Tokenizer.TokenizerException, QueryException {
        if (!this.attemptSkipS("[")) {
            return null;
        }
        if (this.attemptSkipS("]")) {
            return new DArray(List.of());
        }
        ArrayList<Item> values = new ArrayList<Item>();
        do {
            values.add(this.value(true));
        } while (this.attemptSkipS(","));
        this.consumeSkipS("]");
        return new DArray(values);
    }

    private Item object() throws Tokenizer.TokenizerException, QueryException {
        if (!this.attemptSkipS("{")) {
            return null;
        }
        if (this.attemptSkipS("}")) {
            return new ArrayObject(new QNm[0], new Item[0]);
        }
        int len = 0;
        ArrayList<QNm> fields = new ArrayList<QNm>();
        ArrayList<Item> values = new ArrayList<Item>();
        do {
            Str name = this.string();
            this.consumeSkipS(":");
            Item value = this.value(true);
            fields.add(new QNm(null, null, name.stringValue()));
            values.add(value);
            ++len;
        } while (this.attemptSkipS(","));
        this.consumeSkipS("}");
        return new ArrayObject(fields.toArray(new QNm[len]), values.toArray(new Item[len]));
    }

    private Numeric number() throws QueryException, Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laS();
        if (la != null) {
            Tokenizer.Token la2;
            this.consume(la);
            Tokenizer.Token minus = this.laSkipWS("-");
            if (minus != null) {
                this.consume(minus);
            }
            if ((la2 = this.laInteger(true)) != null) {
                this.consume(la2);
                return Int32.parse((String)(minus == null ? la2.string() : "-" + la2.string()));
            }
            la2 = this.laDecimal(true);
            if (la2 != null) {
                this.consume(la2);
                return new Dec((String)(minus == null ? la2.string() : "-" + la2.string()));
            }
            la2 = this.laDouble(true);
            if (la2 != null) {
                this.consume(la2);
                return new Dbl((String)(minus == null ? la2.string() : "-" + la2.string()));
            }
        } else {
            Tokenizer.Token minus = this.laSkipWS("-");
            if (minus != null) {
                this.consume(minus);
            }
            if ((la = this.laInteger(true)) != null) {
                this.consume(la);
                return Int32.parse((String)(minus == null ? la.string() : "-" + la.string()));
            }
            la = this.laDecimal(true);
            if (la != null) {
                this.consume(la);
                return new Dec((String)(minus == null ? la.string() : "-" + la.string()));
            }
            la = this.laDouble(true);
            if (la != null) {
                this.consume(la);
                return new Dbl((String)(minus == null ? la.string() : "-" + la.string()));
            }
        }
        return null;
    }

    private Str string() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laS();
        if (la != null) {
            Tokenizer.Token la2 = this.laString(la, true);
            if (la2 != null) {
                this.consume(la);
                this.consume(la2);
                return new Str(la2.string());
            }
        } else {
            la = this.laString(true);
            if (la != null) {
                this.consume(la);
                return new Str(la.string());
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String s = "{\"bindings\": [        {\"ircEvent\": \"PRIVMSG\", \"method\": \"newURI\", \"regex\": \"^http://.*\"},        {\"ircEvent\": \"PRIVMSG\", \"method\": \"deleteURI\", \"regex\": \"^delete.*\"},        {\"ircEvent\": \"PRIVMSG\", \"method\": \"randomURI\", \"regex\": \"^random.*\"}    ]}";
        Item item = new JSONParser(s).parse();
        try (StringSerializer ser = new StringSerializer(System.out);){
            ser.serialize(item);
            s = "[]";
            item = new JSONParser(s).parse();
            ser.serialize(item);
        }
    }
}

