/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.function.json;

import io.brackit.query.QueryContext;
import io.brackit.query.atomic.QNm;
import io.brackit.query.function.AbstractFunction;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.module.StaticContext;
import io.brackit.query.sequence.BaseIter;
import io.brackit.query.sequence.LazySequence;
import io.brackit.query.util.annotation.FunctionAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FunctionAnnotation(description="Returns an array with the field values of the given record.", parameters={"$record"})
public class Keys
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://jsoniq.org/functions", "jn", "keys");

    public Keys() {
        this(DEFAULT_NAME);
    }

    public Keys(QNm name) {
        super(name, new Signature(SequenceType.ITEM_SEQUENCE, SequenceType.ITEM_SEQUENCE), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) {
        final Sequence sequence = args[0];
        return new LazySequence(this){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    Iter s;
                    final Set<String> stringKeys = new HashSet<String>();
                    final List<Item> keys = new ArrayList<Item>();

                    @Override
                    public Item next() {
                        Item item;
                        if (this.s == null) {
                            this.s = sequence.iterate();
                        }
                        while ((item = this.s.next()) != null) {
                            if (!(item instanceof Object)) continue;
                            Object object = (Object)item;
                            Iter nameIter = object.names().iterate();
                            try {
                                Item name;
                                while ((name = nameIter.next()) != null) {
                                    if (!this.stringKeys.add(name.atomize().stringValue())) continue;
                                    this.keys.add(name);
                                }
                            }
                            finally {
                                if (nameIter == null) continue;
                                nameIter.close();
                            }
                        }
                        if (!this.keys.isEmpty()) {
                            return this.keys.remove(0);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                        if (this.s != null) {
                            this.s.close();
                        }
                    }
                };
            }
        };
    }
}

