/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jdm;

import io.brackit.query.jdm.type.ItemType;
import io.brackit.query.jdm.type.SequenceType;

public class Signature {
    private final SequenceType resultType;
    private final SequenceType[] params;
    private final boolean lastIsVarArg;
    private final ItemType defaultCtxItemType;

    public Signature(SequenceType resultType, SequenceType ... params) {
        this.resultType = resultType;
        this.params = params;
        this.lastIsVarArg = false;
        this.defaultCtxItemType = null;
    }

    public Signature(SequenceType resultType, boolean lastIsVarArg, ItemType defaultCtxItemType, SequenceType ... params) {
        this.resultType = resultType;
        this.params = params;
        this.lastIsVarArg = lastIsVarArg;
        this.defaultCtxItemType = defaultCtxItemType;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public SequenceType[] getParams() {
        return this.params;
    }

    public boolean lastIsVarArg() {
        return this.lastIsVarArg;
    }

    public ItemType defaultCtxItemType() {
        return this.defaultCtxItemType;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append("(");
        if (this.params.length > 0) {
            st.append(this.params[0]);
            for (int i = 1; i < this.params.length; ++i) {
                st.append(", ");
                st.append(this.params[i]);
            }
        }
        st.append(") : ");
        st.append(this.resultType);
        return st.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature s = (Signature)obj;
        if (this.params.length != s.params.length) {
            return false;
        }
        if (!this.resultType.equals(s.resultType) || this.lastIsVarArg != s.lastIsVarArg || this.defaultCtxItemType != null && (s.defaultCtxItemType == null || !this.defaultCtxItemType.equals(s.defaultCtxItemType)) || this.defaultCtxItemType == null && s.defaultCtxItemType != null) {
            return false;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].equals(s.params[i])) continue;
            return false;
        }
        return true;
    }
}

