/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jdm.type;

import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.AnyJsonItemType;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.ItemType;

public final class SequenceType {
    public static SequenceType EMPTY_SEQUENCE = new SequenceType(new AnyItemType(), Cardinality.Zero);
    public static SequenceType ITEM_SEQUENCE = new SequenceType(new AnyItemType(), Cardinality.ZeroOrMany);
    public static SequenceType JSON_ITEM_SEQUENCE = new SequenceType(AnyJsonItemType.ANY_JSON_ITEM, Cardinality.ZeroOrMany);
    public static SequenceType ITEM = new SequenceType(new AnyItemType(), Cardinality.One);
    public static SequenceType JSON_ITEM = new SequenceType(AnyItemType.ANY, Cardinality.One);
    public static SequenceType NODE = new SequenceType(AnyItemType.ANY, Cardinality.One);
    public static SequenceType INTEGER = new SequenceType(AtomicType.INR, Cardinality.One);
    public static SequenceType STRING = new SequenceType(AtomicType.STR, Cardinality.One);
    private final ItemType itemType;
    private final Cardinality cardinality;

    public SequenceType(ItemType itemType, Cardinality cardinality) {
        this.itemType = itemType;
        this.cardinality = cardinality;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    private String cardinalityString() {
        switch (this.cardinality) {
            case OneOrMany: {
                return "+";
            }
            case ZeroOrMany: {
                return "*";
            }
            case ZeroOrOne: {
                return "?";
            }
            case One: 
            case Zero: {
                return "";
            }
        }
        throw new RuntimeException();
    }

    public String toString() {
        return this.cardinality == Cardinality.Zero ? "empty-sequence()" : String.format("%s%s", this.itemType, this.cardinalityString());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SequenceType && ((SequenceType)obj).itemType.equals(this.itemType) && ((SequenceType)obj).cardinality.equals((Object)this.cardinality);
    }
}

