/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.jsonitem;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.json.JsonItem;
import io.brackit.query.util.io.URIHandler;
import io.brackit.query.util.serialize.StringSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

public final class ParserStream
implements Stream<String> {
    private final Iter it;

    public ParserStream(Sequence locs) {
        this.it = locs.iterate();
    }

    @Override
    public String next() throws DocumentException {
        try {
            Item item = this.it.next();
            if (item == null) {
                return null;
            }
            if (item instanceof Atomic) {
                String str = ((Atomic)item).stringValue();
                return new String(URIHandler.getInputStream(str).readAllBytes(), StandardCharsets.UTF_8);
            }
            if (item instanceof JsonItem) {
                JsonItem jsonItem = (JsonItem)item;
                PrintWriter writer = new PrintWriter(new StringWriter());
                new StringSerializer(writer).serialize(jsonItem);
                return writer.toString();
            }
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot create string for item of type: %s", item.itemType());
        }
        catch (QueryException | IOException e) {
            throw new DocumentException(e);
        }
    }

    @Override
    public void close() {
        this.it.close();
    }
}

