/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.module;

import io.brackit.query.atomic.QNm;
import io.brackit.query.function.ConstructorFunction;
import io.brackit.query.function.fn.Abs;
import io.brackit.query.function.fn.AdjustToTimezone;
import io.brackit.query.function.fn.BaseURI;
import io.brackit.query.function.fn.BooleanValue;
import io.brackit.query.function.fn.CardinalityTest;
import io.brackit.query.function.fn.Ceiling;
import io.brackit.query.function.fn.CodepointEqual;
import io.brackit.query.function.fn.CodepointsToString;
import io.brackit.query.function.fn.Collection;
import io.brackit.query.function.fn.Compare;
import io.brackit.query.function.fn.Concat;
import io.brackit.query.function.fn.Count;
import io.brackit.query.function.fn.CurrentDate;
import io.brackit.query.function.fn.CurrentDateTime;
import io.brackit.query.function.fn.CurrentTime;
import io.brackit.query.function.fn.Data;
import io.brackit.query.function.fn.DateTime;
import io.brackit.query.function.fn.DeepEqual;
import io.brackit.query.function.fn.Distinct;
import io.brackit.query.function.fn.Doc;
import io.brackit.query.function.fn.DocumentURI;
import io.brackit.query.function.fn.EmptySequence;
import io.brackit.query.function.fn.Encode;
import io.brackit.query.function.fn.Error;
import io.brackit.query.function.fn.ExtractFromDateTime;
import io.brackit.query.function.fn.ExtractFromDuration;
import io.brackit.query.function.fn.Floor;
import io.brackit.query.function.fn.ImplicitTimezone;
import io.brackit.query.function.fn.IndexOf;
import io.brackit.query.function.fn.InsertBefore;
import io.brackit.query.function.fn.MinMax;
import io.brackit.query.function.fn.Name;
import io.brackit.query.function.fn.Nilled;
import io.brackit.query.function.fn.NodeName;
import io.brackit.query.function.fn.Number;
import io.brackit.query.function.fn.QName;
import io.brackit.query.function.fn.RegEx;
import io.brackit.query.function.fn.Remove;
import io.brackit.query.function.fn.ResolveURI;
import io.brackit.query.function.fn.Reverse;
import io.brackit.query.function.fn.Root;
import io.brackit.query.function.fn.Round;
import io.brackit.query.function.fn.RoundHalfEven;
import io.brackit.query.function.fn.StringCase;
import io.brackit.query.function.fn.StringJoin;
import io.brackit.query.function.fn.StringLength;
import io.brackit.query.function.fn.StringNormalize;
import io.brackit.query.function.fn.StringToCodepoints;
import io.brackit.query.function.fn.StringTranslate;
import io.brackit.query.function.fn.StringValue;
import io.brackit.query.function.fn.Subsequence;
import io.brackit.query.function.fn.Substring;
import io.brackit.query.function.fn.SubstringMatch;
import io.brackit.query.function.fn.SubstringRelative;
import io.brackit.query.function.fn.SumAvg;
import io.brackit.query.function.fn.Trace;
import io.brackit.query.function.fn.Unordered;
import io.brackit.query.function.json.Keys;
import io.brackit.query.function.json.Size;
import io.brackit.query.jdm.Function;
import io.brackit.query.jdm.Signature;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.type.AnyItemType;
import io.brackit.query.jdm.type.AnyNodeType;
import io.brackit.query.jdm.type.AtomicType;
import io.brackit.query.jdm.type.Cardinality;
import io.brackit.query.jdm.type.DocumentType;
import io.brackit.query.jdm.type.NumericType;
import io.brackit.query.jdm.type.SequenceType;
import io.brackit.query.util.Regex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Functions {
    private static final Map<QNm, Function[]> predefined = new HashMap<QNm, Function[]>();
    public static final QNm FN_POSITION = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "position");
    public static final QNm FN_LAST = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "last");
    public static final QNm FN_TRUE = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "true");
    public static final QNm FN_FALSE = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "false");
    public static final QNm FN_DEFAULT_COLLATION = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "default-collation");
    public static final QNm FN_STATIC_BASE_URI = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "static-base-uri");
    public static final QNm FN_COUNT = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "count");
    public static final QNm FN_DISTINCT = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "distinct-values");
    public static final QNm FN_ROOT = new QNm("http://www.w3.org/2005/xpath-functions", "fn", "root");
    private final Map<QNm, Function[]> functions = new HashMap<QNm, Function[]>();
    private final List<Functions> imports = new ArrayList<Functions>();

    public Function resolve(QNm name, int argCount) {
        if (name.getNamespaceURI().equals("http://jsoniq.org/default-function-namespace")) {
            Function function = this.getFunction(name = new QNm("http://www.w3.org/2005/xpath-functions", "fn", name.getLocalName()), argCount);
            if (function != null) {
                return function;
            }
            function = this.getFunction(name = new QNm("http://jsoniq.org/functions", "http://jsoniq.org/functions", name.getLocalName()), argCount);
            if (function != null) {
                return function;
            }
            name = new QNm("http://brackit.org/ns/bit", "bit", name.getLocalName());
            return this.getFunction(name, argCount);
        }
        return this.getFunction(name, argCount);
    }

    private Function getFunction(QNm name, int argCount) {
        Function[] predefFunsInDefaultNamespace;
        Function[] predefFuns;
        ArrayList<Function> availableFunctions = new ArrayList<Function>();
        Function[] declaredFuns = this.functions.get(name);
        if (declaredFuns != null) {
            availableFunctions.addAll(Arrays.asList(declaredFuns));
        }
        if ((predefFuns = predefined.get(name)) != null) {
            availableFunctions.addAll(Arrays.asList(predefFuns));
        }
        for (Functions imported : this.imports) {
            Function[] importedFuns = imported.functions.get(name);
            if (importedFuns == null) continue;
            availableFunctions.addAll(Arrays.asList(importedFuns));
        }
        if (availableFunctions.isEmpty() && name.getNamespaceURI().isEmpty() && (predefFunsInDefaultNamespace = predefined.get(new QNm("http://www.w3.org/2005/xpath-functions", "fn", name.getLocalName()))) != null) {
            availableFunctions.addAll(Arrays.asList(predefFunsInDefaultNamespace));
        }
        if (availableFunctions.isEmpty()) {
            return null;
        }
        for (Function f : availableFunctions) {
            Signature sig = f.getSignature();
            SequenceType[] params = sig.getParams();
            int parCnt = params.length;
            if (argCount != parCnt && (!sig.lastIsVarArg() || argCount != parCnt - 1 && argCount <= parCnt)) continue;
            return f;
        }
        return null;
    }

    public void declare(Function function) {
        Function[] funs = this.functions.get(function.getName());
        if (funs == null) {
            funs = new Function[]{function};
        } else {
            funs = Arrays.copyOf(funs, funs.length + 1);
            funs[funs.length - 1] = function;
        }
        this.functions.put(function.getName(), funs);
    }

    public void importFunctions(Functions functions) {
        this.imports.add(functions);
    }

    public Map<QNm, Function[]> getDeclaredFunctions() {
        return Collections.unmodifiableMap(this.functions);
    }

    public Map<QNm, Function[]> getPredefinedFunctions() {
        return Collections.unmodifiableMap(predefined);
    }

    public static void predefine(Function function) {
        Function[] funs = predefined.computeIfAbsent(function.getName(), k -> new Function[1]);
        for (int i = 0; i < funs.length; ++i) {
            if (funs[i] != null) continue;
            funs[i] = function;
            return;
        }
        funs = Arrays.copyOf(funs, funs.length + 1);
        funs[funs.length - 1] = function;
        predefined.put(function.getName(), funs);
    }

    static {
        Functions.predefine(new NodeName(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "node-name"), new Signature(new SequenceType(AtomicType.QNM, Cardinality.ZeroOrOne), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Nilled(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "nilled"), new Signature(new SequenceType(AtomicType.QNM, Cardinality.ZeroOrOne), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new BaseURI(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "base-uri"), new Signature(new SequenceType(AtomicType.AURI, Cardinality.ZeroOrOne), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new BaseURI(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "base-uri"), new Signature(new SequenceType(AtomicType.AURI, Cardinality.ZeroOrOne), false, AnyNodeType.ANY_NODE, new SequenceType[0])));
        Functions.predefine(new Data(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "data"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), false, AnyNodeType.ANY_NODE, new SequenceType[0])));
        Functions.predefine(new Data(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "data"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new StringValue(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "string"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringValue(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "string"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), false, AnyItemType.ANY, new SequenceType[0])));
        Functions.predefine(new DocumentURI(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "document-uri"), new Signature(new SequenceType(AtomicType.AURI, Cardinality.ZeroOrOne), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Error(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "error"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.Zero), new SequenceType[0])));
        Functions.predefine(new Error(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "error"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.Zero), new SequenceType(AtomicType.QNM, Cardinality.One))));
        Functions.predefine(new Error(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "error"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.Zero), new SequenceType(AtomicType.QNM, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new Error(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "error"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.Zero), new SequenceType(AtomicType.QNM, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new Trace(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "trace"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new DateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "dateTime"), new Signature(new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne), new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne))));
        Functions.predefine(new Abs(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "abs"), new Signature(new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne), new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Ceiling(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "ceiling"), new Signature(new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne), new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Floor(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "floor"), new Signature(new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne), new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Round(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "round"), new Signature(new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne), new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne))));
        Functions.predefine(new RoundHalfEven(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "round-half-to-even"), new Signature(new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne), new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne))));
        Functions.predefine(new RoundHalfEven(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "round-half-to-even"), new Signature(new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne), new SequenceType(NumericType.INSTANCE, Cardinality.ZeroOrOne), new SequenceType(AtomicType.INR, Cardinality.One))));
        Functions.predefine(new StringToCodepoints(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "string-to-codepoints"), new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new CodepointsToString(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "codepoints-to-string"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.INR, Cardinality.ZeroOrMany))));
        Functions.predefine(new Compare(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "compare"), new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new Compare(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "compare"), new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new CodepointEqual(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "codepoint-equal"), new Signature(new SequenceType(AtomicType.BOOL, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new Concat(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "concat"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.One), true, null, new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringCase(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "upper-case"), true, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringCase(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "lower-case"), false, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringLength(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "string-length"), new Signature(new SequenceType(AtomicType.INT, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringLength(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "string-length"), new Signature(new SequenceType(AtomicType.INT, Cardinality.One), false, AtomicType.STR, new SequenceType[0])));
        Functions.predefine(new StringJoin(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "string-join"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new Substring(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "substring"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DBL, Cardinality.One))));
        Functions.predefine(new Substring(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "substring"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DBL, Cardinality.One), new SequenceType(AtomicType.DBL, Cardinality.One))));
        Functions.predefine(new StringTranslate(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "translate"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new StringNormalize(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "normalize-space"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringNormalize(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "normalize-space"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), false, AtomicType.STR, new SequenceType[0])));
        Functions.predefine(new StringCase(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "upper-case"), true, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringCase(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "lower-case"), false, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new StringTranslate(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "translate"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new ResolveURI(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "resolve-uri"), new Signature(new SequenceType(AtomicType.AURI, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new ResolveURI(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "resolve-uri"), new Signature(new SequenceType(AtomicType.AURI, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new Encode(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "encode-for-uri"), Encode.Mode.ENCODE_FOR_URI, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new Encode(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "iri-to-uri"), Encode.Mode.IRI_TO_URI, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new Encode(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "escape-html-uri"), Encode.Mode.HTML_URI, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new SubstringMatch(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "contains"), SubstringMatch.Mode.CONTAINS, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new SubstringMatch(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "contains"), SubstringMatch.Mode.CONTAINS, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new SubstringMatch(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "starts-with"), SubstringMatch.Mode.STARTS_WITH, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new SubstringMatch(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "starts-with"), SubstringMatch.Mode.STARTS_WITH, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new SubstringMatch(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "ends-with"), SubstringMatch.Mode.ENDS_WITH, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new SubstringMatch(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "ends-with"), SubstringMatch.Mode.ENDS_WITH, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new SubstringRelative(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "substring-before"), true, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new SubstringRelative(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "substring-before"), true, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new SubstringRelative(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "substring-after"), false, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new SubstringRelative(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "substring-after"), false, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new RegEx(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "matches"), Regex.Mode.MATCH, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new RegEx(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "matches"), Regex.Mode.MATCH, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new RegEx(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "replace"), Regex.Mode.REPLACE, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new RegEx(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "replace"), Regex.Mode.REPLACE, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new RegEx(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "tokenize"), Regex.Mode.TOKENIZE, new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new RegEx(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "tokenize"), Regex.Mode.TOKENIZE, new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new BooleanValue(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "true"), false, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType[0])));
        Functions.predefine(new BooleanValue(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "false"), false, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType[0])));
        Functions.predefine(new BooleanValue(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "not"), true, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new ExtractFromDuration(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "years-from-duration"), ExtractFromDuration.Comp.YEARS, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DUR, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDuration(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "months-from-duration"), ExtractFromDuration.Comp.MONTHS, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DUR, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDuration(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "days-from-duration"), ExtractFromDuration.Comp.DAYS, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DUR, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDuration(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "hours-from-duration"), ExtractFromDuration.Comp.HOURS, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DUR, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDuration(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "minutes-from-duration"), ExtractFromDuration.Comp.MINUTES, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DUR, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDuration(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "seconds-from-duration"), ExtractFromDuration.Comp.SECONDS, new Signature(new SequenceType(AtomicType.DEC, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DUR, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "year-from-dateTime"), ExtractFromDateTime.Source.DATE_TIME, ExtractFromDateTime.Comp.YEAR, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "month-from-dateTime"), ExtractFromDateTime.Source.DATE_TIME, ExtractFromDateTime.Comp.MONTH, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "day-from-dateTime"), ExtractFromDateTime.Source.DATE_TIME, ExtractFromDateTime.Comp.DAY, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "hours-from-dateTime"), ExtractFromDateTime.Source.DATE_TIME, ExtractFromDateTime.Comp.HOURS, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "minutes-from-dateTime"), ExtractFromDateTime.Source.DATE_TIME, ExtractFromDateTime.Comp.MINUTES, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "seconds-from-dateTime"), ExtractFromDateTime.Source.DATE_TIME, ExtractFromDateTime.Comp.SECONDS, new Signature(new SequenceType(AtomicType.DEC, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "timezone-from-dateTime"), ExtractFromDateTime.Source.DATE_TIME, ExtractFromDateTime.Comp.TIMEZONE, new Signature(new SequenceType(AtomicType.DTD, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "year-from-date"), ExtractFromDateTime.Source.DATE, ExtractFromDateTime.Comp.YEAR, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "month-from-date"), ExtractFromDateTime.Source.DATE, ExtractFromDateTime.Comp.MONTH, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "day-from-date"), ExtractFromDateTime.Source.DATE, ExtractFromDateTime.Comp.DAY, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "timezone-from-date"), ExtractFromDateTime.Source.DATE, ExtractFromDateTime.Comp.TIMEZONE, new Signature(new SequenceType(AtomicType.DTD, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "hours-from-time"), ExtractFromDateTime.Source.TIME, ExtractFromDateTime.Comp.HOURS, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "minutes-from-time"), ExtractFromDateTime.Source.TIME, ExtractFromDateTime.Comp.MINUTES, new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "seconds-from-time"), ExtractFromDateTime.Source.TIME, ExtractFromDateTime.Comp.SECONDS, new Signature(new SequenceType(AtomicType.DEC, Cardinality.ZeroOrOne), new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne))));
        Functions.predefine(new ExtractFromDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "timezone-from-time"), ExtractFromDateTime.Source.TIME, ExtractFromDateTime.Comp.TIMEZONE, new Signature(new SequenceType(AtomicType.DTD, Cardinality.ZeroOrOne), new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne))));
        Functions.predefine(new AdjustToTimezone(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "adjust-dateTime-to-timezone"), AdjustToTimezone.Source.DATE_TIME, new Signature(new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne))));
        Functions.predefine(new AdjustToTimezone(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "adjust-dateTime-to-timezone"), AdjustToTimezone.Source.DATE_TIME, new Signature(new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATI, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DTD, Cardinality.ZeroOrOne))));
        Functions.predefine(new AdjustToTimezone(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "adjust-date-to-timezone"), AdjustToTimezone.Source.DATE, new Signature(new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne))));
        Functions.predefine(new AdjustToTimezone(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "adjust-date-to-timezone"), AdjustToTimezone.Source.DATE, new Signature(new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DATE, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DTD, Cardinality.ZeroOrOne))));
        Functions.predefine(new AdjustToTimezone(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "adjust-time-to-timezone"), AdjustToTimezone.Source.TIME, new Signature(new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne), new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne))));
        Functions.predefine(new AdjustToTimezone(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "adjust-time-to-timezone"), AdjustToTimezone.Source.TIME, new Signature(new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne), new SequenceType(AtomicType.TIME, Cardinality.ZeroOrOne), new SequenceType(AtomicType.DTD, Cardinality.ZeroOrOne))));
        Functions.predefine(new QName(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "QName"), new Signature(new SequenceType(AtomicType.QNM, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new Name(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "name"), Name.Mode.NAME, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), false, AnyNodeType.ANY_NODE, new SequenceType[0])));
        Functions.predefine(new Name(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "name"), Name.Mode.NAME, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Name(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "local-name"), Name.Mode.LOCAL_NAME, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), false, AnyNodeType.ANY_NODE, new SequenceType[0])));
        Functions.predefine(new Name(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "local-name"), Name.Mode.LOCAL_NAME, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Name(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "namespace-uri"), Name.Mode.NAMESPACE_URI, new Signature(new SequenceType(AtomicType.AURI, Cardinality.One), false, AnyNodeType.ANY_NODE, new SequenceType[0])));
        Functions.predefine(new Name(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "namespace-uri"), Name.Mode.NAMESPACE_URI, new Signature(new SequenceType(AtomicType.AURI, Cardinality.One), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new Number(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "number"), new Signature(new SequenceType(AtomicType.DBL, Cardinality.One), false, AnyItemType.ANY, new SequenceType[0])));
        Functions.predefine(new Number(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "number"), new Signature(new SequenceType(AtomicType.DBL, Cardinality.One), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne))));
        Functions.predefine(new Root(FN_ROOT, new Signature(new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne), false, AnyNodeType.ANY_NODE, new SequenceType[0])));
        Functions.predefine(new Root(FN_ROOT, new Signature(new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrOne))));
        Functions.predefine(new BooleanValue(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "boolean"), false, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new IndexOf(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "index-of"), new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.One))));
        Functions.predefine(new IndexOf(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "index-of"), new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new EmptySequence(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "empty"), true, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new EmptySequence(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "exists"), false, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new Distinct(FN_DISTINCT, new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new Distinct(FN_DISTINCT, new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany))));
        Functions.predefine(new InsertBefore(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "insert-before"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.INR, Cardinality.One), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany))));
        Functions.predefine(new Remove(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "remove"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.INR, Cardinality.One))));
        Functions.predefine(new Reverse(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "reverse"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany))));
        Functions.predefine(new Subsequence(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "subsequence"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.DBL, Cardinality.One))));
        Functions.predefine(new Subsequence(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "subsequence"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.DBL, Cardinality.One), new SequenceType(AtomicType.DBL, Cardinality.One))));
        Functions.predefine(new Subsequence(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "subsequence"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AtomicType.DBL, Cardinality.One), new SequenceType(AtomicType.DBL, Cardinality.One))));
        Functions.predefine(new Subsequence(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "subsequence"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AtomicType.DBL, Cardinality.One))));
        Functions.predefine(new Reverse(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "reverse"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new Remove(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "remove"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AtomicType.INR, Cardinality.One))));
        Functions.predefine(new InsertBefore(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "insert-before"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AtomicType.INR, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new IndexOf(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "index-of"), new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.One))));
        Functions.predefine(new IndexOf(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "index-of"), new Signature(new SequenceType(AtomicType.INR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new Unordered(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "unordered"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new CardinalityTest(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "zero-or-one"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrOne), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany)), Cardinality.ZeroOrOne));
        Functions.predefine(new CardinalityTest(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "one-or-more"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.OneOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany)), Cardinality.OneOrMany));
        Functions.predefine(new CardinalityTest(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "exactly-one"), new Signature(new SequenceType(AnyItemType.ANY, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany)), Cardinality.One));
        Functions.predefine(new DeepEqual(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "deep-equal"), new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new DeepEqual(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "deep-equal"), new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One))));
        Functions.predefine(new Count(FN_COUNT, new Signature(new SequenceType(AtomicType.INR, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany))));
        Functions.predefine(new MinMax(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "min"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany)), true));
        Functions.predefine(new MinMax(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "min"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One)), true));
        Functions.predefine(new MinMax(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "max"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany)), false));
        Functions.predefine(new MinMax(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "max"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One)), false));
        Functions.predefine(new SumAvg(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "avg"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany)), true));
        Functions.predefine(new SumAvg(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "sum"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany)), false));
        Functions.predefine(new SumAvg(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "sum"), new Signature(new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrMany), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne)), false));
        Functions.predefine(new Doc(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "doc"), true, new Signature(new SequenceType(DocumentType.DOC, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new Doc(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "doc"), true, new Signature(new SequenceType(DocumentType.DOC, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AtomicType.INT, Cardinality.ZeroOrOne))));
        Functions.predefine(new Doc(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "doc-available"), false, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new Collection(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "collection"), new Signature(new SequenceType(DocumentType.DOC, Cardinality.ZeroOrMany), new SequenceType[0])));
        Functions.predefine(new Collection(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "collection"), new Signature(new SequenceType(DocumentType.DOC, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne))));
        Functions.predefine(new CurrentDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "current-dateTime"), new Signature(new SequenceType(AtomicType.DATI, Cardinality.One), new SequenceType[0])));
        Functions.predefine(new CurrentDate(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "current-date"), new Signature(new SequenceType(AtomicType.DATE, Cardinality.One), new SequenceType[0])));
        Functions.predefine(new CurrentTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "current-time"), new Signature(new SequenceType(AtomicType.TIME, Cardinality.One), new SequenceType[0])));
        Functions.predefine(new ImplicitTimezone(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "implicit-timezone"), new Signature(new SequenceType(AtomicType.DTD, Cardinality.One), new SequenceType[0])));
        Functions.predefine(new CurrentDateTime(new QNm("http://www.w3.org/2005/xpath-functions", "fn", "default-collation"), new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType[0])));
        Functions.predefine(new Keys());
        Functions.predefine(new Size());
        for (Type type : Type.builtInTypes) {
            if (type == Type.ANA || type == Type.NOT) continue;
            Functions.predefine(new ConstructorFunction(type.getName(), new Signature(new SequenceType(new AtomicType(type), Cardinality.ZeroOrOne), new SequenceType(AtomicType.ANA, Cardinality.ZeroOrOne)), type));
        }
    }
}

