/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.module;

import io.brackit.query.atomic.QNm;
import io.brackit.query.module.NamespaceDecl;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Namespaces {
    public static final String LOCAL_NSURI = "http://www.w3.org/2005/xquery-local-functions";
    public static final String FN_NSURI = "http://www.w3.org/2005/xpath-functions";
    public static final String DEFAULT_FN_NSURI = "http://jsoniq.org/default-function-namespace";
    public static final String FNMATH_NSURI = "http://www.w3.org/2005/xpath-functions/math";
    public static final String XSI_NSURI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XS_NSURI = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_NSURI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NSURI = "http://www.w3.org/2000/xmlns";
    public static final String ERR_NSURI = "http://www.w3.org/2005/xqt-errors";
    public static final String LOCAL_PREFIX = "local";
    public static final String FN_PREFIX = "fn";
    public static final String XSI_PREFIX = "xsi";
    public static final String XS_PREFIX = "xs";
    public static final String XML_PREFIX = "xml";
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String ERR_PREFIX = "err";
    public static final QNm ERR_CODE = new QNm("http://www.w3.org/2005/xqt-errors", "err", "code");
    public static final QNm ERR_DESCRIPTION = new QNm("http://www.w3.org/2005/xqt-errors", "err", "description");
    public static final QNm ERR_VALUE = new QNm("http://www.w3.org/2005/xqt-errors", "err", "value");
    public static final QNm ERR_MODULE = new QNm("http://www.w3.org/2005/xqt-errors", "err", "module");
    public static final QNm ERR_LINE_NUMBER = new QNm("http://www.w3.org/2005/xqt-errors", "err", "line-number");
    public static final QNm ERR_COLUMN_NUMBER = new QNm("http://www.w3.org/2005/xqt-errors", "err", "column-number");
    protected static final Map<String, NamespaceDecl> predefined = new HashMap<String, NamespaceDecl>();
    protected final Map<String, NamespaceDecl> namespaces = new TreeMap<String, NamespaceDecl>();
    protected final Namespaces parent;
    protected String defaultFunctionNamespace = "http://jsoniq.org/default-function-namespace";
    protected String defaultElementNamespace = null;

    public Namespaces() {
        this.parent = null;
    }

    public Namespaces(Namespaces parent) {
        this.parent = parent;
        this.defaultElementNamespace = parent.defaultElementNamespace;
        this.defaultFunctionNamespace = parent.defaultFunctionNamespace;
    }

    public static void predefine(String prefix, String nsUri) {
        predefined.put(prefix, new NamespaceDecl(prefix, nsUri));
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String defaultFunctionNamespace) {
        this.defaultFunctionNamespace = defaultFunctionNamespace;
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(String defaultElementNamespace) {
        this.defaultElementNamespace = defaultElementNamespace;
    }

    public void declare(String prefix, String nsURI) {
        this.namespaces.put(prefix, new NamespaceDecl(prefix, nsURI));
    }

    public String resolve(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        NamespaceDecl nsDecl = this.namespaces.get(prefix);
        if (nsDecl != null) {
            return nsDecl.getUri();
        }
        if (this.parent != null) {
            return this.parent.resolve(prefix);
        }
        nsDecl = predefined.get(prefix);
        if (nsDecl != null) {
            return nsDecl.getUri();
        }
        return null;
    }

    public boolean isPredefined(String prefix) {
        return predefined.containsKey(prefix);
    }

    static {
        Namespaces.predefine(XML_PREFIX, XML_NSURI);
        Namespaces.predefine(XS_PREFIX, XS_NSURI);
        Namespaces.predefine(XSI_PREFIX, XSI_NSURI);
        Namespaces.predefine(FN_PREFIX, FN_NSURI);
        Namespaces.predefine(LOCAL_PREFIX, LOCAL_NSURI);
        Namespaces.predefine(ERR_PREFIX, ERR_NSURI);
        Namespaces.predefine("bit", "http://brackit.org/ns/bit");
        Namespaces.predefine("io", "http://brackit.org/ns/io");
        Namespaces.predefine("jn", "http://jsoniq.org/functions");
    }
}

