/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import io.brackit.query.node.parser.NodeSubtreeListener;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractBuilder<E extends Node<E>>
implements NodeSubtreeListener<E>,
NodeSubtreeHandler {
    private Node[] stack = new Node[5];
    private int stackSize;
    private E parent;
    private final E rootParent;
    private Map<String, String> nsMappings;

    @Override
    public void endMapping(String prefix) throws DocumentException {
    }

    @Override
    public void startMapping(String prefix, String uri) throws DocumentException {
        if (this.nsMappings == null) {
            this.nsMappings = new TreeMap<String, String>();
        }
        this.nsMappings.put(prefix, uri);
    }

    public AbstractBuilder(E parent) {
        this.parent = parent;
        this.rootParent = parent;
        this.stack[this.stackSize++] = parent;
    }

    public AbstractBuilder() {
        this.rootParent = null;
    }

    protected abstract E buildDocument() throws DocumentException;

    protected abstract E buildElement(E var1, QNm var2, Map<String, String> var3) throws DocumentException;

    protected abstract E buildAttribute(E var1, QNm var2, Atomic var3) throws DocumentException;

    protected abstract E buildText(E var1, Atomic var2) throws DocumentException;

    protected abstract E buildComment(E var1, Atomic var2) throws DocumentException;

    protected abstract E buildProcessingInstruction(E var1, QNm var2, Atomic var3) throws DocumentException;

    private void prepare() throws DocumentException {
        if (this.stackSize == 0 && this.rootParent != null) {
            throw new DocumentException("A root already exists", new Object[0]);
        }
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize * 3 / 2 + 1);
        }
    }

    public E root() throws DocumentException {
        Node root;
        Node node = root = this.rootParent == null ? this.stack[0] : this.stack[1];
        if (root == null) {
            throw new DocumentException("No root node has been build", new Object[0]);
        }
        return (E)root;
    }

    @Override
    public void begin() throws DocumentException {
    }

    @Override
    public void end() throws DocumentException {
    }

    @Override
    public void fail() throws DocumentException {
    }

    @Override
    public void beginFragment() throws DocumentException {
    }

    @Override
    public void endFragment() throws DocumentException {
    }

    @Override
    public void startDocument() throws DocumentException {
        this.prepare();
        this.parent = this.buildDocument();
        this.stack[this.stackSize++] = this.parent;
    }

    @Override
    public void endDocument() throws DocumentException {
        this.parent = --this.stackSize > 0 ? this.stack[this.stackSize - 1] : null;
    }

    @Override
    public <T extends E> void startElement(T node) throws DocumentException {
        this.prepare();
        this.parent = this.buildElement(this.parent, node.getName(), null);
        this.stack[this.stackSize++] = this.parent;
    }

    @Override
    public <T extends E> void endElement(T node) throws DocumentException {
        this.parent = --this.stackSize > 0 ? this.stack[this.stackSize - 1] : null;
    }

    @Override
    public <T extends E> void attribute(T node) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildAttribute(this.parent, node.getName(), node.getValue());
    }

    @Override
    public <T extends E> void text(T node) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildText(this.parent, node.getValue().asUna());
    }

    @Override
    public <T extends E> void comment(T node) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildComment(this.parent, node.getValue().asStr());
    }

    @Override
    public <T extends E> void processingInstruction(T node) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildProcessingInstruction(this.parent, node.getName(), node.getValue().asStr());
    }

    @Override
    public void startElement(QNm name) throws DocumentException {
        this.prepare();
        this.parent = this.buildElement(this.parent, name, this.nsMappings);
        this.stack[this.stackSize++] = this.parent;
        this.nsMappings = null;
    }

    @Override
    public void endElement(QNm name) throws DocumentException {
        this.parent = --this.stackSize > 0 ? this.stack[this.stackSize - 1] : null;
    }

    @Override
    public void attribute(QNm name, Atomic value) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildAttribute(this.parent, name, value);
    }

    @Override
    public void text(Atomic content) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildText(this.parent, content);
    }

    @Override
    public void comment(Atomic content) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildComment(this.parent, content);
    }

    @Override
    public void processingInstruction(QNm target, Atomic content) throws DocumentException {
        this.prepare();
        this.stack[this.stackSize] = this.buildProcessingInstruction(this.parent, target, content);
    }
}

