/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node;

import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.OperationNotSupportedException;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.NodeCollection;
import io.brackit.query.jdm.node.NodeFactory;
import io.brackit.query.jdm.node.NodeStore;
import io.brackit.query.node.d2linked.D2NodeFactory;
import io.brackit.query.node.parser.DocumentParser;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.util.io.URIHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class SimpleNodeStore
implements NodeStore {
    private final Map<String, NodeCollection<?>> docs = new HashMap();

    @Override
    public NodeCollection<?> create(String name) throws DocumentException {
        NodeCollection<?> coll = this.getNodeFactory().collection(name);
        this.docs.put(name, coll);
        return coll;
    }

    @Override
    public NodeCollection<?> create(String name, NodeSubtreeParser parser) throws DocumentException {
        NodeCollection<?> coll = this.getNodeFactory().collection(name, parser);
        this.docs.put(name, coll);
        return coll;
    }

    @Override
    public NodeCollection<?> create(String name, Stream<NodeSubtreeParser> parsers) throws DocumentException {
        NodeCollection<?> coll = this.getNodeFactory().collection(name, parsers);
        this.docs.put(name, coll);
        return coll;
    }

    @Override
    public void drop(String name) throws DocumentException {
        if (this.docs.remove(name) == null) {
            throw new DocumentException("Collection %s not found", name);
        }
    }

    @Override
    public NodeCollection<?> lookup(String name) throws DocumentException {
        NodeCollection<Object> coll = this.docs.get(name);
        if (coll != null) {
            return coll;
        }
        try {
            InputStream in = URIHandler.getInputStream(URI.create(name));
            DocumentParser p = new DocumentParser(in);
            Object doc = this.getNodeFactory().build(p);
            coll = doc.getCollection();
            this.docs.put(name, coll);
            return coll;
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e, "Collection %s not found", name);
        }
    }

    protected NodeFactory<?> getNodeFactory() {
        return new D2NodeFactory();
    }

    @Override
    public void makeDir(String path) throws DocumentException {
        throw new OperationNotSupportedException();
    }
}

