/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.d2linked;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Una;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.OperationNotSupportedException;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.d2linked.D2Node;
import io.brackit.query.node.d2linked.D2NodeBuilder;
import io.brackit.query.node.d2linked.ElementD2Node;
import io.brackit.query.node.parser.NodeSubtreeParser;

public final class AttributeD2Node
extends D2Node {
    QNm name;
    Una value;

    AttributeD2Node(ElementD2Node parent, int[] division, QNm name, Atomic value) throws DocumentException {
        super(parent, division);
        this.name = this.checkName(name);
        this.value = value.asUna();
    }

    AttributeD2Node(ElementD2Node parent, QNm name, Atomic value) throws DocumentException {
        this(parent, FIRST, name, value);
    }

    public AttributeD2Node(QNm name, Atomic value) throws DocumentException {
        this(null, FIRST, name, value);
    }

    private QNm checkName(QNm name) throws DocumentException {
        if (name.getPrefix() == null || this.parent == null) {
            return name;
        }
        return ((ElementD2Node)this.parent).checkName(name);
    }

    @Override
    public QNm getName() throws DocumentException {
        return this.name;
    }

    @Override
    public Atomic getValue() {
        return this.value;
    }

    @Override
    public void setName(QNm name) throws DocumentException {
        this.name = this.checkName(name);
    }

    @Override
    public void setValue(Atomic value) throws DocumentException {
        this.value = value.asUna();
    }

    @Override
    public Kind getKind() {
        return Kind.ATTRIBUTE;
    }

    @Override
    public boolean isChildOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isAttributeOf(Node<?> node) {
        return this.parent != null && this.parent == node;
    }

    @Override
    public boolean isDescendantOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isDescendantOrSelfOf(Node<?> node) {
        return this == node;
    }

    @Override
    public boolean isFollowingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isFollowingSiblingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isPrecedingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isPrecedingSiblingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isSiblingOf(Node<?> node) {
        return false;
    }

    @Override
    public D2Node replaceWith(Kind kind, QNm name, Atomic value) throws DocumentException {
        if (kind != Kind.ATTRIBUTE) {
            throw new DocumentException("Cannot replace attribute with node of type: %s.", new Object[]{kind});
        }
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        return this.parent.setAttribute(name, value);
    }

    @Override
    public D2Node replaceWith(Node<?> node) throws DocumentException {
        Kind kind = node.getKind();
        if (kind != Kind.ATTRIBUTE) {
            throw new DocumentException("Cannot replace attribute with node of type: %s.", new Object[]{kind});
        }
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        return this.parent.setAttribute(this.name, this.value);
    }

    @Override
    public D2Node replaceWith(NodeSubtreeParser parser) throws DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(){

            @Override
            D2Node first(Kind kind, QNm name, Atomic value) throws DocumentException {
                if (kind != Kind.ATTRIBUTE) {
                    throw new DocumentException("Cannot replace attribute with node of type: %s.", new Object[]{kind});
                }
                if (AttributeD2Node.this.parent == null) {
                    throw new DocumentException("Cannot replace node without parent", new Object[0]);
                }
                return AttributeD2Node.this.parent.setAttribute(name, value);
            }
        };
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    @Override
    public D2Node getPreviousSibling() throws DocumentException {
        return null;
    }

    @Override
    public D2Node getNextSibling() throws DocumentException {
        return null;
    }

    @Override
    public D2Node append(Kind kind, QNm name, Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node append(Node<?> child) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node append(NodeSubtreeParser parser) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertAfter(Kind kind, QNm name, Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertAfter(Node<?> node) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertAfter(NodeSubtreeParser parser) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertBefore(Kind kind, QNm name, Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertBefore(Node<?> node) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertBefore(NodeSubtreeParser parser) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(Kind kind, QNm name, Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(Node<?> child) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(NodeSubtreeParser parser) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    public String toString() {
        return String.format("(type='%s', name='%s', value='%s')", new Object[]{Kind.ATTRIBUTE, this.name, this.value});
    }
}

