/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.d2linked;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.OperationNotSupportedException;
import io.brackit.query.jdm.Scope;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.AbstractNode;
import io.brackit.query.node.d2linked.D2NodeBuilder;
import io.brackit.query.node.d2linked.D2NodeCollection;
import io.brackit.query.node.d2linked.D2NodeParser;
import io.brackit.query.node.d2linked.ParentD2Node;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.node.stream.AtomStream;
import io.brackit.query.node.stream.EmptyStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class D2Node
extends AbstractNode<D2Node> {
    protected static final AtomicInteger ID_SEQUENCE = new AtomicInteger();
    public static final int NO_ADDITIONAL_STATIC_DIVISIONS = 63;
    public static final int MAX_STATIC_DIVISION = 129;
    public static final int[] FIRST = new int[]{3};
    private static final int[][] STATIC_DIVISIONS = new int[64][];
    public static final int NODE_CLASS_ID = 1;
    protected final ParentD2Node parent;
    protected final int[] division;
    protected D2Node sibling;
    protected int localFragmentID;

    protected D2Node(ParentD2Node parent, int[] division) {
        this.parent = parent;
        this.division = division;
        this.localFragmentID = parent == null ? this.localFragmentID() : parent.localFragmentID;
    }

    private D2Node getRoot() {
        D2Node parent = this;
        while (parent.parent != null) {
            parent = parent.parent;
        }
        return parent;
    }

    public D2NodeCollection getCollection() {
        return this.parent == null ? null : this.getRoot().getCollection();
    }

    @Override
    public final int getNodeClassID() {
        return 1;
    }

    private int localFragmentID() {
        int localFragmentID = ID_SEQUENCE.incrementAndGet();
        while (localFragmentID < 0) {
            if (ID_SEQUENCE.compareAndSet(localFragmentID, 1)) {
                localFragmentID = 1;
                return localFragmentID;
            }
            localFragmentID = ID_SEQUENCE.incrementAndGet();
        }
        return localFragmentID;
    }

    @Override
    protected final int cmpInternal(D2Node node) {
        if (node == this) {
            return 0;
        }
        if (this.localFragmentID != node.localFragmentID) {
            return this.localFragmentID < node.localFragmentID ? -1 : 1;
        }
        D2Node c = null;
        D2Node cp = this;
        while (cp != null) {
            D2Node lcap = null;
            D2Node lca = node;
            while (lca != null) {
                if (lca == cp) {
                    Kind nkind;
                    if (lca == this) {
                        return -1;
                    }
                    if (lca == node) {
                        return 1;
                    }
                    Kind kind = c.getKind();
                    if (kind == Kind.ATTRIBUTE ^ (nkind = lcap.getKind()) == Kind.ATTRIBUTE) {
                        return kind == Kind.ATTRIBUTE ? -1 : 1;
                    }
                    return this.compare(c.division, lcap.division);
                }
                lcap = lca;
                lca = lca.parent;
            }
            c = cp;
            cp = cp.parent;
        }
        return -1;
    }

    protected final boolean isInSubtreeOf(D2Node n) {
        ParentD2Node a = this.parent;
        while (a != null) {
            if (a == n) {
                return true;
            }
            a = a.parent;
        }
        return false;
    }

    protected final int[] siblingAfter(int[] p) {
        return this.getDivision(p[0] + ((p[0] & 1) != 0 ? 2 : 1));
    }

    protected final int[] getDivision(int value) {
        int[] nArray;
        if (value <= 129) {
            nArray = STATIC_DIVISIONS[value / 2 - 1];
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = value;
        }
        return nArray;
    }

    protected final int[] siblingBetween(int[] p, int[] n) {
        if (n == null || n[0] - p[0] > 2) {
            return this.siblingAfter(p);
        }
        int length = Math.min(n.length, p.length);
        for (int i = 0; i < length; ++i) {
            if (n[i] == p[i]) continue;
            if (n[i] < p[i]) {
                throw new IllegalArgumentException(String.format("Illegal sibling divisions: %s > %s", Arrays.toString(p), Arrays.toString(n)));
            }
            if ((p[i] & 1) == 0) {
                if (n[i] - p[i] > 1) {
                    int[] r = Arrays.copyOf(p, i + 1);
                    int n2 = i;
                    r[n2] = r[n2] + 1;
                    return r;
                }
                int[] r = Arrays.copyOf(p, i + 2);
                int n3 = i + 1;
                r[n3] = r[n3] + (r[i + 1] == 0 ? 3 : ((r[i + 1] & 1) == 0 ? 1 : 2));
                return r;
            }
            if ((n[i] & 1) == 0) {
                if (n[i] - p[i] > 2) {
                    int[] r = Arrays.copyOf(p, i + 1);
                    int n4 = i;
                    r[n4] = r[n4] + 2;
                    return r;
                }
                int[] r = Arrays.copyOf(p, i + 2);
                int n5 = i + 1;
                r[n5] = r[n5] + (r[i + 1] == 0 ? 3 : ((r[i + 1] & 1) == 0 ? 1 : 2));
                return r;
            }
            if (n[i] - p[i] > 2) {
                int[] r = Arrays.copyOf(p, i + 1);
                int n6 = i;
                r[n6] = r[n6] + 2;
                return r;
            }
            int[] r = Arrays.copyOf(p, i + 2);
            int n7 = i;
            r[n7] = r[n7] + 1;
            r[i + 1] = 3;
            return r;
        }
        throw new IllegalArgumentException(String.format("Illegal sibling divisions: %s and %s", Arrays.toString(p), Arrays.toString(n)));
    }

    protected final int[] siblingBefore(int[] n) {
        if (n.length == 1) {
            int[] nArray;
            if (n[0] > 3) {
                nArray = this.getDivision(n[0] - 2);
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = 2;
                nArray = nArray2;
                nArray2[1] = 3;
            }
            return nArray;
        }
        for (int i = 0; i < n.length; ++i) {
            if (n[i] <= 3) continue;
            int[] r = Arrays.copyOf(n, i + 1);
            int n2 = i;
            r[n2] = r[n2] - ((r[i] & 1) == 0 ? 1 : 2);
            return r;
        }
        int[] r = Arrays.copyOf(n, n.length + 1);
        int n3 = r.length - 2;
        r[n3] = r[n3] - 1;
        r[r.length - 1] = 3;
        return r;
    }

    private int compare(int[] value1, int[] value2) {
        int length1 = value1.length;
        int length2 = value2.length;
        int length = Math.min(length1, length2);
        int pos = -1;
        while (++pos < length) {
            int v1 = value1[pos];
            int v2 = value2[pos];
            if (v1 == v2) continue;
            return v1 < v2 ? -1 : 1;
        }
        return length1 - length2;
    }

    @Override
    public Scope getScope() {
        return null;
    }

    @Override
    public D2Node getParent() throws DocumentException {
        return this.parent;
    }

    @Override
    public final boolean isSelfOf(Node<?> node) {
        return node == this;
    }

    @Override
    public boolean isAncestorOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isAncestorOrSelfOf(Node<?> node) {
        return this == node;
    }

    @Override
    public boolean isAttributeOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isChildOf(Node<?> node) {
        return node != null && this.parent == node;
    }

    @Override
    public boolean isDescendantOf(Node<?> node) {
        return node != null && (this.parent == node || this.parent != null && this.parent.isDescendantOf(node));
    }

    @Override
    public boolean isDescendantOrSelfOf(Node<?> node) {
        return node != null && (this == node || this.parent == node || this.parent != null && this.parent.isDescendantOrSelfOf(node));
    }

    @Override
    public boolean isParentOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isFollowingOf(Node<?> node) {
        D2Node n;
        block7: {
            block6: {
                if (node == this || !(node instanceof D2Node)) break block6;
                n = (D2Node)node;
                if (this.getKind() != Kind.ATTRIBUTE) break block7;
            }
            return false;
        }
        if (this.cmpInternal(n) <= 0) {
            return false;
        }
        ParentD2Node c = this.parent;
        while (c != null) {
            if (c == n) {
                return false;
            }
            c = c.parent;
        }
        return true;
    }

    @Override
    public boolean isFollowingSiblingOf(Node<?> node) {
        D2Node n;
        block5: {
            block4: {
                if (this.parent == null || node == this || !(node instanceof D2Node)) break block4;
                n = (D2Node)node;
                if (node.getKind() != Kind.ATTRIBUTE) break block5;
            }
            return false;
        }
        if (this.parent != n.parent) {
            return false;
        }
        return this.compare(this.division, n.division) > 0;
    }

    @Override
    public boolean isPrecedingOf(Node<?> node) {
        D2Node n;
        block7: {
            block6: {
                if (node == this || !(node instanceof D2Node)) break block6;
                n = (D2Node)node;
                if (this.getKind() != Kind.ATTRIBUTE) break block7;
            }
            return false;
        }
        if (this.cmpInternal(n) >= 0) {
            return false;
        }
        n = n.parent;
        while (n != null) {
            if (n == this) {
                return false;
            }
            n = n.parent;
        }
        return true;
    }

    @Override
    public boolean isPrecedingSiblingOf(Node<?> node) {
        D2Node n;
        block5: {
            block4: {
                if (this.parent == null || node == this || !(node instanceof D2Node)) break block4;
                n = (D2Node)node;
                if (node.getKind() != Kind.ATTRIBUTE) break block5;
            }
            return false;
        }
        if (this.parent != n.parent) {
            return false;
        }
        return this.compare(this.division, n.division) < 0;
    }

    @Override
    public final boolean isRoot() {
        return this.getKind() == Kind.ELEMENT && this.parent != null && this.parent.getKind() == Kind.DOCUMENT;
    }

    @Override
    public boolean isSiblingOf(Node<?> node) {
        return node != null && node != this && this.parent != null && node.isChildOf(this.parent);
    }

    @Override
    public final boolean isDocumentRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isDocumentOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean hasAttributes() throws DocumentException {
        return false;
    }

    @Override
    public boolean hasChildren() throws DocumentException {
        return false;
    }

    @Override
    public void delete() throws DocumentException {
        if (this.parent != null) {
            if (this.getKind() == Kind.ATTRIBUTE) {
                this.parent.deleteAttribute(this.getName());
            } else {
                this.parent.deleteChild(this);
            }
        }
    }

    @Override
    public void parse(NodeSubtreeHandler handler) throws DocumentException {
        new D2NodeParser(this).parse(handler);
    }

    @Override
    public D2Node getNextSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.nextSiblingOf(this);
    }

    @Override
    public D2Node getPreviousSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.previousSiblingOf(this);
    }

    @Override
    public D2Node getFirstChild() throws DocumentException {
        return null;
    }

    @Override
    public D2Node getLastChild() throws DocumentException {
        return null;
    }

    @Override
    public Stream<D2Node> getChildren() throws DocumentException {
        return new EmptyStream<D2Node>();
    }

    @Override
    public D2Node getAttribute(QNm name) throws DocumentException {
        return null;
    }

    @Override
    public Stream<D2Node> getAttributes() throws DocumentException {
        return new EmptyStream<D2Node>();
    }

    @Override
    public Stream<D2Node> getSubtree() throws DocumentException {
        return new AtomStream<D2Node>(this);
    }

    @Override
    public Stream<? extends D2Node> getDescendantOrSelf() throws DocumentException {
        return new AtomStream<D2Node>(this);
    }

    @Override
    public void setName(QNm name) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void setValue(Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node setAttribute(Node<?> attribute) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node setAttribute(QNm name, Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public boolean deleteAttribute(QNm name) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node append(Node<?> child) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node append(NodeSubtreeParser parser) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node append(Kind kind, QNm name, Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(Kind kind, QNm name, Atomic value) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(Node<?> child) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(NodeSubtreeParser parser) throws DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertAfter(Kind kind, QNm name, Atomic value) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("%s has no parent", this);
        }
        return this.parent.insertAfter(kind, name, value);
    }

    @Override
    public D2Node insertAfter(Node<?> child) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("%s has no parent", this);
        }
        return this.parent.insertAfter(this, child);
    }

    @Override
    public D2Node insertAfter(NodeSubtreeParser parser) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("%s has no parent", this);
        }
        return this.parent.insertAfter(this, parser);
    }

    @Override
    public D2Node insertBefore(Kind kind, QNm name, Atomic value) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("%s has no parent", this);
        }
        return this.parent.insertBefore(kind, name, value);
    }

    @Override
    public D2Node insertBefore(Node<?> child) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("%s has no parent", this);
        }
        return this.parent.insertBefore(this, child);
    }

    @Override
    public D2Node insertBefore(NodeSubtreeParser parser) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("%s has no parent", this);
        }
        return this.parent.insertBefore(this, parser);
    }

    @Override
    public D2Node replaceWith(Kind kind, QNm name, Atomic value) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        return this.parent.replace(this, kind, name, value);
    }

    @Override
    public D2Node replaceWith(Node<?> node) throws DocumentException {
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        return this.parent.replace(this, node);
    }

    @Override
    public D2Node replaceWith(NodeSubtreeParser parser) throws DocumentException {
        final D2Node me = this;
        D2NodeBuilder builder = new D2NodeBuilder(){

            @Override
            D2Node first(Kind kind, QNm name, Atomic value) throws DocumentException {
                if (D2Node.this.parent == null) {
                    throw new DocumentException("Cannot replace node without parent", new Object[0]);
                }
                return D2Node.this.parent.replace(me, kind, name, value);
            }
        };
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    static {
        D2Node.STATIC_DIVISIONS[0] = FIRST;
        for (int i = 0; i < 63; ++i) {
            D2Node.STATIC_DIVISIONS[i + 1] = new int[]{(i + 2) * 2 + 1};
        }
    }
}

