/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.d2linked;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.node.AbstractBuilder;
import io.brackit.query.node.d2linked.AttributeD2Node;
import io.brackit.query.node.d2linked.CommentD2Node;
import io.brackit.query.node.d2linked.D2Node;
import io.brackit.query.node.d2linked.D2NodeCollection;
import io.brackit.query.node.d2linked.DocumentD2Node;
import io.brackit.query.node.d2linked.ElementD2Node;
import io.brackit.query.node.d2linked.PID2Node;
import io.brackit.query.node.d2linked.ParentD2Node;
import io.brackit.query.node.d2linked.TextD2Node;
import java.util.Map;

public class D2NodeBuilder
extends AbstractBuilder<D2Node> {
    private final D2Node sibling;
    private final boolean right;
    private final D2NodeCollection coll;

    public D2NodeBuilder(String name) throws DocumentException {
        this(new D2NodeCollection(name));
    }

    public D2NodeBuilder(D2NodeCollection coll) throws DocumentException {
        this.coll = coll;
        this.sibling = null;
        this.right = true;
    }

    public D2NodeBuilder() throws DocumentException {
        this.coll = null;
        this.sibling = null;
        this.right = true;
    }

    public D2NodeBuilder(D2Node parent, D2Node sibling, boolean right) throws DocumentException {
        super(parent);
        this.coll = parent != null ? parent.getCollection() : null;
        this.sibling = sibling;
        this.right = right;
    }

    @Override
    protected D2Node buildDocument() throws DocumentException {
        return this.coll == null ? new DocumentD2Node() : new DocumentD2Node(this.coll);
    }

    @Override
    protected D2Node buildAttribute(D2Node parent, QNm name, Atomic value) throws DocumentException {
        return parent != null ? parent.setAttribute(name, value) : this.first(Kind.ATTRIBUTE, name, value);
    }

    D2Node first(Kind kind, QNm name, Atomic value) throws DocumentException {
        D2Node child;
        if (kind == Kind.ELEMENT) {
            child = new ElementD2Node(name);
        } else if (kind == Kind.TEXT) {
            child = new TextD2Node(value);
        } else if (kind == Kind.COMMENT) {
            child = new CommentD2Node(value);
        } else if (kind == Kind.PROCESSING_INSTRUCTION) {
            child = new PID2Node(name, value);
        } else if (kind == Kind.ATTRIBUTE) {
            child = new AttributeD2Node(name, value);
        } else {
            throw new DocumentException("Illegal node kind: %s", new Object[]{kind});
        }
        return child;
    }

    @Override
    protected D2Node buildElement(D2Node parent, QNm name, Map<String, String> nsMappings) throws DocumentException {
        ElementD2Node e = parent != null ? (ElementD2Node)((ParentD2Node)parent).insertChild(this.sibling, Kind.ELEMENT, name, null, this.right) : (ElementD2Node)this.first(Kind.ELEMENT, name, null);
        e.nsMappings = nsMappings;
        return e;
    }

    @Override
    protected D2Node buildText(D2Node parent, Atomic text) throws DocumentException {
        if (parent != null) {
            return ((ParentD2Node)parent).insertChild(this.sibling, Kind.TEXT, null, text.asUna(), this.right);
        }
        return this.first(Kind.TEXT, null, text);
    }

    @Override
    protected D2Node buildComment(D2Node parent, Atomic text) throws DocumentException {
        if (parent != null) {
            return ((ParentD2Node)parent).insertChild(this.sibling, Kind.COMMENT, null, text, this.right);
        }
        return this.first(Kind.COMMENT, null, text);
    }

    @Override
    protected D2Node buildProcessingInstruction(D2Node parent, QNm target, Atomic text) throws DocumentException {
        if (parent != null) {
            return ((ParentD2Node)parent).insertChild(this.sibling, Kind.PROCESSING_INSTRUCTION, target, text, this.right);
        }
        return this.first(Kind.PROCESSING_INSTRUCTION, target, text);
    }
}

