/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.parser;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Stream;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.node.stream.ArrayStream;
import io.brackit.query.node.stream.AtomStream;

public class CollectionParser
implements NodeSubtreeParser {
    private final Stream<NodeSubtreeParser> parsers;

    public CollectionParser(Stream<NodeSubtreeParser> parsers) {
        this.parsers = parsers;
    }

    public CollectionParser(NodeSubtreeParser parser) {
        this.parsers = new AtomStream<NodeSubtreeParser>(parser);
    }

    public CollectionParser(NodeSubtreeParser[] parsers) {
        this.parsers = new ArrayStream<NodeSubtreeParser>(parsers);
    }

    @Override
    public void parse(NodeSubtreeHandler handler) throws DocumentException {
        CollectionHandler collHandler = new CollectionHandler(this, handler);
        handler.begin();
        NodeSubtreeParser current = null;
        while ((current = this.parsers.next()) != null) {
            current.parse(collHandler);
        }
        this.parsers.close();
        handler.end();
    }

    private class CollectionHandler
    implements NodeSubtreeHandler {
        private final NodeSubtreeHandler handler;
        private int level;

        public CollectionHandler(CollectionParser collectionParser, NodeSubtreeHandler handler) {
            this.handler = handler;
            this.level = 0;
        }

        @Override
        public void attribute(QNm name, Atomic value) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Attribute on top level!", new Object[0]);
            }
            this.handler.attribute(name, value);
        }

        @Override
        public void begin() throws DocumentException {
        }

        @Override
        public void beginFragment() throws DocumentException {
            this.handler.beginFragment();
        }

        @Override
        public void comment(Atomic content) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Comment on top level!", new Object[0]);
            }
            this.handler.comment(content);
        }

        @Override
        public void end() throws DocumentException {
        }

        @Override
        public void endDocument() throws DocumentException {
            this.handler.endDocument();
        }

        @Override
        public void endElement(QNm name) throws DocumentException {
            this.handler.endElement(name);
            --this.level;
            if (this.level == 0) {
                this.handler.endDocument();
            }
        }

        @Override
        public void endFragment() throws DocumentException {
            this.handler.endFragment();
        }

        @Override
        public void endMapping(String prefix) throws DocumentException {
            this.handler.endMapping(prefix);
        }

        @Override
        public void fail() throws DocumentException {
            this.handler.fail();
        }

        @Override
        public void processingInstruction(QNm target, Atomic content) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Processing instruction on top level!", new Object[0]);
            }
            this.handler.processingInstruction(target, content);
        }

        @Override
        public void startDocument() throws DocumentException {
            this.handler.startDocument();
        }

        @Override
        public void startElement(QNm name) throws DocumentException {
            if (this.level == 0) {
                this.handler.startDocument();
            }
            ++this.level;
            this.handler.startElement(name);
        }

        @Override
        public void startMapping(String prefix, String uri) throws DocumentException {
            this.handler.startMapping(prefix, uri);
        }

        @Override
        public void text(Atomic content) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Text on top level!", new Object[0]);
            }
            this.handler.text(content);
        }
    }
}

