/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.parser;

import io.brackit.query.jdm.DocumentException;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import io.brackit.query.node.parser.NodeSubtreeParser;
import io.brackit.query.node.parser.RelativeEntityResolver;
import io.brackit.query.node.parser.SAX2SubtreeHandlerAdapter;
import io.brackit.query.util.Cfg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class DocumentParser
implements NodeSubtreeParser {
    public static final String IGNORE_COMMENTS = "org.brackit.xquery.node.parser.DocumentParser.ignoreComments";
    private final XMLReader xmlReader;
    private final InputSource source;
    private DTDHandler dtdHandler;
    private boolean retainWhitespace;
    private boolean parseAsFragment;
    private String baseDir;

    public DocumentParser(File xmlFile) throws DocumentException, FileNotFoundException {
        this(new InputSource(new BufferedReader(new FileReader(xmlFile))));
        File dir = xmlFile.getParentFile();
        if (dir != null) {
            this.baseDir = dir.getAbsolutePath();
        }
    }

    public DocumentParser(String xmlFragment) throws DocumentException {
        this(new InputSource(new StringReader(xmlFragment)));
    }

    public DocumentParser(InputStream in) throws DocumentException {
        this(new InputSource(in));
    }

    public DocumentParser(InputSource source) throws DocumentException {
        this.source = source;
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new DocumentException((Throwable)e, "Error creating document parser.", new Object[0]);
        }
    }

    public InputSource getSource() {
        return this.source;
    }

    public void setParseAsFragment(boolean parseAsFragment) {
        this.parseAsFragment = parseAsFragment;
    }

    public void setRetainWhitespace(boolean retainWhitespace) {
        this.retainWhitespace = retainWhitespace;
    }

    @Override
    public void parse(NodeSubtreeHandler handler) throws DocumentException {
        try {
            SAX2SubtreeHandlerAdapter handlerAdapter = new SAX2SubtreeHandlerAdapter(handler);
            if (this.retainWhitespace) {
                handlerAdapter.setRetainWhitespace(true);
            }
            if (this.parseAsFragment) {
                handlerAdapter.setParseAsFragment(true);
            }
            this.xmlReader.setContentHandler(handlerAdapter);
            if (this.baseDir != null) {
                this.xmlReader.setEntityResolver(new RelativeEntityResolver(this.baseDir));
            }
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            if (!Cfg.asBool(IGNORE_COMMENTS, false)) {
                this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handlerAdapter);
            }
            this.xmlReader.parse(this.source);
        }
        catch (IOException | SAXException e) {
            throw new DocumentException((Throwable)e, "Error parsing document.", new Object[0]);
        }
    }
}

