/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.parser;

import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Stream;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.node.parser.NodeSubtreeListener;
import io.brackit.query.node.parser.NodeSubtreeProcessor;
import io.brackit.query.util.log.Logger;
import java.util.List;

public class NodeStreamSubtreeProcessor<E extends Node<E>>
extends NodeSubtreeProcessor<E> {
    private static final Logger log = Logger.getLogger(NodeStreamSubtreeProcessor.class);
    private boolean displayNodeIDs;
    private final Stream<? extends E> scanner;

    public NodeStreamSubtreeProcessor(Stream<? extends E> scanner, List<NodeSubtreeListener<? super E>> listeners) {
        super(listeners);
        this.scanner = scanner;
    }

    public void process() throws DocumentException {
        try {
            Node node;
            Node[] stack = new Node[10];
            int stackSize = 0;
            this.notifyBegin();
            while ((node = (Node)this.scanner.next()) != null) {
                Kind kind;
                if (stackSize == 0) {
                    this.notifyBeginFragment();
                }
                if ((kind = node.getKind()) != Kind.ATTRIBUTE) {
                    while (stackSize > 0 && !stack[stackSize - 1].isParentOf(node)) {
                        Node ancestor;
                        if ((ancestor = stack[--stackSize]).getKind() == Kind.ELEMENT) {
                            this.notifyEndElement(ancestor);
                            continue;
                        }
                        this.notifyEndDocument();
                    }
                }
                if (kind == Kind.ELEMENT) {
                    this.notifyStartElement(node);
                    if (stackSize == stack.length) {
                        newElementStack = new Node[stackSize * 3 / 2 + 1];
                        System.arraycopy(stack, 0, newElementStack, 0, stackSize);
                        stack = newElementStack;
                    }
                    stack[stackSize++] = node;
                } else if (kind == Kind.ATTRIBUTE) {
                    this.notifyAttribute(node);
                } else if (kind == Kind.TEXT) {
                    this.notifyText(node);
                } else if (kind == Kind.COMMENT) {
                    this.notifyComment(node);
                } else if (kind == Kind.PROCESSING_INSTRUCTION) {
                    this.notifyProcessingInstruction(node);
                } else if (kind == Kind.DOCUMENT) {
                    this.notifyBeginDocument();
                    if (stackSize == stack.length) {
                        newElementStack = new Node[stackSize * 3 / 2 + 1];
                        System.arraycopy(stack, 0, newElementStack, 0, stackSize);
                        stack = newElementStack;
                    }
                    stack[stackSize++] = node;
                }
                if (stackSize != 0) continue;
                this.notifyEndFragment();
            }
            while (stackSize > 0) {
                Node ancestor;
                if ((ancestor = stack[--stackSize]).getKind() == Kind.ELEMENT) {
                    this.notifyEndElement(ancestor);
                } else {
                    this.notifyEndDocument();
                }
                if (stackSize != 0) continue;
                this.notifyEndFragment();
            }
            this.notifyEnd();
        }
        catch (Exception e) {
            this.notifyFail();
            log.error(e);
            throw new DocumentException(e);
        }
        finally {
            this.scanner.close();
        }
    }
}

