/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.parser;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.atomic.Una;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.node.parser.NodeSubtreeHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class SAX2SubtreeHandlerAdapter
extends DefaultHandler2 {
    private final NodeSubtreeHandler handler;
    private boolean inComment;
    private final TrimmingStringBuilder content;
    private boolean retainWhitespace;
    private boolean parseAsFragment;

    public SAX2SubtreeHandlerAdapter(NodeSubtreeHandler handler) {
        this.handler = handler;
        this.content = new TrimmingStringBuilder();
    }

    public boolean isRetainWhitespace() {
        return this.retainWhitespace;
    }

    public void setRetainWhitespace(boolean retainWhitespace) {
        this.retainWhitespace = retainWhitespace;
    }

    public boolean isParseAsFragment() {
        return this.parseAsFragment;
    }

    public void setParseAsFragment(boolean parseAsFragment) {
        this.parseAsFragment = parseAsFragment;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        File temp = new File(systemId);
        if (temp.exists()) {
            return new InputSource(new BufferedReader(new FileReader(systemId)));
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inComment) {
            try {
                this.handleText();
            }
            catch (DocumentException e) {
                throw new SAXException(e);
            }
            this.inComment = false;
        }
        this.content.append(ch, start, length);
    }

    private void handleText() throws DocumentException {
        if (this.content.length() > 0) {
            if (this.retainWhitespace || this.content.trim().length() > 0) {
                String text = this.content.toString();
                if (!this.inComment) {
                    this.handler.text(new Una(text));
                } else {
                    this.handler.comment(new Str(text));
                }
            }
            this.content.clear();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.handleText();
            if (!this.parseAsFragment) {
                this.handler.endDocument();
            }
            this.handler.endFragment();
            this.handler.end();
        }
        catch (DocumentException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (this.content.length() > 0) {
                this.handleText();
            }
            this.handler.endElement(new QNm(uri, localName, name));
        }
        catch (DocumentException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        try {
            this.handler.fail();
        }
        catch (DocumentException e1) {
            throw new SAXException(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        try {
            this.handler.fail();
        }
        catch (DocumentException e1) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.handler.begin();
            this.handler.beginFragment();
            if (!this.parseAsFragment) {
                this.handler.startDocument();
            }
        }
        catch (DocumentException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        try {
            int pos;
            if (this.content.length() > 0) {
                this.handleText();
            }
            String prefix = (pos = name.indexOf(":")) == -1 ? null : name.substring(0, pos);
            this.handler.startElement(new QNm(uri, prefix, localName));
            for (int i = 0; i < attributes.getLength(); ++i) {
                name = attributes.getQName(i);
                pos = name.indexOf(":");
                prefix = pos == -1 ? null : name.substring(0, pos);
                this.handler.attribute(new QNm(attributes.getURI(i), prefix, attributes.getLocalName(i)), new Una(attributes.getValue(i)));
            }
        }
        catch (DocumentException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.inComment) {
            try {
                this.handleText();
            }
            catch (DocumentException e) {
                throw new SAXException(e);
            }
            this.inComment = true;
        }
        this.content.append(ch, start, length);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        try {
            this.handler.endMapping(prefix);
        }
        catch (DocumentException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.handler.startMapping(prefix, uri);
        }
        catch (QueryException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.content.length() > 0) {
                this.handleText();
            }
            this.handler.processingInstruction(new QNm(target), new Una(data));
        }
        catch (DocumentException e) {
            throw new SAXException(e);
        }
    }

    private static class TrimmingStringBuilder {
        private char[] val = new char[20];
        private int start;
        private int end;

        private TrimmingStringBuilder() {
        }

        public int length() {
            return this.end - this.start;
        }

        public TrimmingStringBuilder trim() {
            while (this.start < this.end && this.val[this.start] <= ' ') {
                ++this.start;
            }
            while (this.start < this.end && this.val[this.end - 1] <= ' ') {
                --this.end;
            }
            return this;
        }

        public void clear() {
            this.start = 0;
            this.end = 0;
        }

        public void append(char[] ch, int offset, int length) {
            int newEnd = this.end + length;
            if (newEnd >= this.val.length) {
                int newLength = this.val.length * 3 / 2 + 1;
                if (newEnd > newLength) {
                    newLength = newEnd;
                }
                char[] newVal = new char[newLength];
                System.arraycopy(this.val, 0, newVal, 0, this.end);
                this.val = newVal;
            }
            System.arraycopy(ch, offset, this.val, this.end, length);
            this.end += length;
        }

        public String toString() {
            return new String(this.val, this.start, this.end - this.start);
        }
    }
}

